/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.editor;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nickyb.sqleonardo.querybuilder.QueryStyledDocument;

public class SQLStyledDocument
extends QueryStyledDocument {
    private static final String DELIMITER_COMMENT_MULTI_LINE_START = "/*";
    private static final String DELIMITER_COMMENT_MULTI_LINE_END = "*/";
    private static final String DELIMITER_COMMENT_SINGLE_LINE = "//";
    private MutableAttributeSet commentAttributSet = new SimpleAttributeSet();

    public SQLStyledDocument() {
        StyleConstants.setForeground(this.commentAttributSet, new Color(63, 127, 95));
    }

    @Override
    protected void doSyntaxHighlight(String content, int startOffset, int endOffset) throws BadLocationException {
        this.setCharacterAttributes(startOffset, endOffset - startOffset, this.defaultAttributSet, true);
        this.checkComments(content, startOffset, endOffset);
    }

    private void checkComments(String content, int startOffset, int endOffset) {
        int index = content.lastIndexOf(DELIMITER_COMMENT_MULTI_LINE_START, endOffset);
        if (index > -1) {
            int index2 = content.indexOf(DELIMITER_COMMENT_MULTI_LINE_END, index);
            if (index2 == -1 || index2 > endOffset) {
                this.setCharacterAttributes(index, endOffset - index + 1, this.commentAttributSet, false);
                return;
            }
            if (index2 >= startOffset) {
                this.setCharacterAttributes(index, index2 + 2 - index, this.commentAttributSet, false);
                return;
            }
        }
        if ((index = content.indexOf(DELIMITER_COMMENT_SINGLE_LINE, startOffset)) > -1 && index < endOffset) {
            this.setCharacterAttributes(index, endOffset - index + 1, this.commentAttributSet, false);
            endOffset = index - 1;
        }
        if (startOffset > endOffset) {
            return;
        }
        this.checkKeywords(content, startOffset, endOffset);
    }

    @Override
    protected void checkKeywords(String content, int startOffset, int endOffset) {
        super.checkKeywords(content, startOffset, endOffset);
        String line = content.substring(startOffset, endOffset);
        this.checkKeyword(line, "DELETE", startOffset);
        this.checkKeyword(line, "INSERT", startOffset);
        this.checkKeyword(line, "INTO", startOffset);
        this.checkKeyword(line, "VALUES", startOffset);
        this.checkKeyword(line, "UPDATE", startOffset);
        this.checkKeyword(line, "SET", startOffset);
        this.checkKeyword(line, "ADD", startOffset);
        this.checkKeyword(line, "ALTER", startOffset);
        this.checkKeyword(line, "CREATE", startOffset);
        this.checkKeyword(line, "DROP", startOffset);
        this.checkKeyword(line, "CONSTRAINT", startOffset);
        this.checkKeyword(line, "REFERENCES", startOffset);
        this.checkKeyword(line, "PRIMARY KEY", startOffset);
        this.checkKeyword(line, "FOREIGN KEY", startOffset);
        this.checkKeyword(line, "COLUMN", startOffset);
        this.checkKeyword(line, "INDEX", startOffset);
        this.checkKeyword(line, "TABLE", startOffset);
        this.checkKeyword(line, "VIE", startOffset);
    }
}

