/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.define;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.environment.Application;

public class ColumnsChooser
extends AbstractDialogConfirm
implements ItemListener {
    private JComboBox listviews;
    private JList columns;

    private ColumnsChooser(String dvname, String defaultmetaview) {
        super((Component)Application.window, dvname + " - choose columns", 350, 275);
        Application.session.mount("$PREFERENCES");
        Application.session.home();
        Application.session.jump("metaview." + dvname);
        Vector vmv = new Vector();
        Enumeration e = Application.session.jumps();
        while (e.hasMoreElements()) {
            vmv.addElement(e.nextElement());
        }
        Object[] omv = vmv.toArray();
        Arrays.sort(omv);
        BorderLayoutPanel mask = new BorderLayoutPanel();
        this.listviews = new JComboBox<Object>(omv);
        mask.setComponentNorth(this.listviews);
        this.columns = new JList();
        mask.setComponentCenter(new JScrollPane(this.columns));
        this.listviews.addItemListener(this);
        this.listviews.setSelectedItem(defaultmetaview);
        this.getContentPane().add(mask);
    }

    @Override
    protected boolean onConfirm() {
        if (this.listviews.getSelectedItem() == null) {
            return false;
        }
        String metaview = this.listviews.getSelectedItem().toString();
        String dvname = this.getTitle().substring(0, this.getTitle().lastIndexOf(45) - 1);
        Application.session.mount("$PREFERENCES");
        Application.session.home();
        Application.session.jump("metaview." + dvname);
        ArrayList al = Application.session.jump(metaview);
        for (int i = 0; i < al.size(); ++i) {
            Object[] col = (Object[])al.get(i);
            col[1] = metaview.equals("table types") && (col[0].equals("TABLE_NAME") || col[0].equals("TABLE_TYPE")) ? new Boolean(true) : new Boolean(this.columns.isSelectedIndex(i));
        }
        return true;
    }

    @Override
    protected void onOpen() {
        this.itemStateChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object[] col;
        int i;
        if (this.listviews.getSelectedItem() == null) {
            return;
        }
        String metaview = this.listviews.getSelectedItem().toString();
        String dvname = this.getTitle().substring(0, this.getTitle().lastIndexOf(45) - 1);
        Application.session.mount("$PREFERENCES");
        Application.session.home();
        Application.session.jump("metaview." + dvname);
        ArrayList al = Application.session.jump(metaview);
        Vector<String> vColumns = new Vector<String>();
        for (i = 0; i < al.size(); ++i) {
            col = (Object[])al.get(i);
            vColumns.addElement(col[0].toString());
        }
        this.columns.setListData(vColumns);
        for (i = 0; i < al.size(); ++i) {
            col = (Object[])al.get(i);
            if (!((Boolean)col[1]).booleanValue()) continue;
            this.columns.addSelectionInterval(i, i);
        }
    }

    public static void showDialog(String dvname, String defaultmetaview) {
        ColumnsChooser dlg = new ColumnsChooser(dvname, defaultmetaview);
        dlg.setVisible(true);
    }

    public static void list(String dvname, String metaview, ListView lv, ResultSet rs) throws SQLException {
        int i;
        Application.session.mount("$PREFERENCES");
        Application.session.home();
        Application.session.jump("metaview." + dvname);
        ArrayList cols = Application.session.jump(metaview);
        lv.reset();
        if (cols.size() == 0) {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnName(i);
                lv.addColumn(name);
                cols.add(new Object[]{name, new Boolean(true)});
            }
        } else {
            for (int i2 = 0; i2 < cols.size(); ++i2) {
                Object[] col = (Object[])cols.get(i2);
                if (!((Boolean)col[1]).booleanValue()) continue;
                lv.addColumn(col[0].toString());
            }
        }
        while (rs.next()) {
            Object[] rowdata = new Object[cols.size()];
            int j = 0;
            for (i = 0; i < rowdata.length; ++i) {
                Object[] col = (Object[])cols.get(i);
                if (!((Boolean)col[1]).booleanValue()) continue;
                rowdata[j++] = rs.getObject(i + 1);
                if (rowdata[j - 1] == null || !(rowdata[j - 1] instanceof String)) continue;
                rowdata[j - 1] = rowdata[j - 1].toString().trim();
            }
            lv.addRow(rowdata);
        }
        rs.close();
    }
}

