/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;

public class TaskRetrieve
implements Runnable {
    private int limit;
    private ContentPane target = null;
    private Statement stmt = null;
    private ResultSet rs = null;

    public TaskRetrieve(ContentPane target) {
        this(target, 0);
    }

    public TaskRetrieve(ContentPane target, int limit) {
        this.target = target;
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String syntax = this.target.getQueryModel().toString(false);
            if (this.target.getHandlerKey() != null) {
                int i;
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.target.getHandlerKey());
                this.stmt = ch.get().createStatement();
                this.stmt.setMaxRows(this.limit);
                this.rs = this.stmt.executeQuery(syntax);
                for (i = 1; i <= this.getColumnCount(); ++i) {
                    String l = this.getColumnLabel(i);
                    this.target.getView().addColumn(l, this.getColumnType(i));
                }
                this.target.getView().onTableChanged(false);
                for (i = 1; i <= this.getColumnCount(); ++i) {
                    String t = this.getColumnLabel(i) + " : " + this.getColumnTypeName(i) + " " + this.getColumnNullable(i);
                    this.target.getView().setToolTipText(i - 1, t);
                }
                int row = 1;
                while (this.target.isBusy() && this.rs.next()) {
                    Object[] rowdata = new Object[this.getColumnCount()];
                    for (int i2 = 1; i2 <= this.getColumnCount(); ++i2) {
                        rowdata[i2 - 1] = this.rs.getString(i2);
                    }
                    this.target.getView().addRow(rowdata, false);
                    if (row == ContentModel.MAX_BLOCK_RECORDS) {
                        this.target.getView().onTableChanged(true);
                    }
                    if (row % ContentModel.MAX_BLOCK_RECORDS == 0) {
                        this.target.doRefreshStatus();
                    }
                    ++row;
                }
                this.rs.close();
            }
        }
        catch (SQLException sqle) {
            Application.println(sqle, true);
        }
        finally {
            this.target.getView().onTableChanged(true);
            this.target.doStop();
            this.target.doRefreshStatus();
        }
    }

    private int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    private String getColumnLabel(int index) throws SQLException {
        return this.rs.getMetaData().getColumnLabel(index);
    }

    private String getColumnNullable(int index) throws SQLException {
        return this.rs.getMetaData().isNullable(index) == 1 ? "(null)" : "(not null)";
    }

    private int getColumnType(int index) throws SQLException {
        return this.rs.getMetaData().getColumnType(index);
    }

    private String getColumnTypeName(int index) throws SQLException {
        return this.rs.getMetaData().getColumnTypeName(index).toLowerCase();
    }

    public static boolean isNumberType(int type) {
        return type == -5 || type == -7 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7 || type == 5;
    }
}

