/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.AbstractMaskPerform;

public class MaskImport
extends AbstractMaskPerform {
    private AbstractChoice iChoice;

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.iChoice.getComponentCount(); ++i) {
            this.iChoice.getComponent(i).setEnabled(b);
        }
    }

    @Override
    void setType(short type, String tname, String fname) {
        if (this.iChoice != null) {
            this.remove(this.iChoice);
        }
        this.progress.setValue(0);
        this.progress.setMaximum(0);
        if (type == 1) {
            if (!fname.endsWith(".txt")) {
                fname = fname + ".txt";
            }
            this.iChoice = new TxtChoice();
            this.setComponentCenter(this.iChoice);
        }
        this.lblFile.setText("file: " + fname);
    }

    @Override
    void init() {
        super.init();
        this.progress.setValue(0);
        this.progress.setMaximum(this.iChoice.open());
    }

    @Override
    void next() {
        String line = this.iChoice.nextln();
        Object[] rowdata = new Object[this.view.getColumnCount()];
        this.iChoice.flush(line, rowdata);
        this.view.addRow(rowdata, true);
        this.progress.setValue(this.progress.getValue() + line.length() + 1);
    }

    @Override
    boolean finished() {
        if (this.progress.getValue() == this.progress.getMaximum()) {
            this.iChoice.close();
            this.view.onTableChanged(true);
            this.view.getControl().doRefreshStatus();
            this.btnStop.setEnabled(false);
            this.lblMsg.setText("ready!");
            return true;
        }
        return false;
    }

    private class TxtChoice
    extends AbstractChoice {
        JCheckBox cbxHeader;
        JCheckBox cbxNull;
        JCheckBox cbxTrim;
        JRadioButton rbTab;
        JRadioButton rbOther;
        JTextField txtDelimiter;

        TxtChoice() {
            JPanel pnl1 = new JPanel(new GridLayout(3, 1));
            this.cbxHeader = new JCheckBox("with header");
            pnl1.add(this.cbxHeader);
            this.cbxNull = new JCheckBox("null if blanks");
            pnl1.add(this.cbxNull);
            this.cbxTrim = new JCheckBox("trim value");
            pnl1.add(this.cbxTrim);
            JPanel pnl2 = new JPanel(new FlowLayout(0));
            pnl2.add(new JLabel("delimiter:"));
            this.rbTab = new JRadioButton("tab", true);
            pnl2.add(this.rbTab);
            this.rbOther = new JRadioButton("other");
            pnl2.add(this.rbOther);
            this.txtDelimiter = new JTextField(";", 5);
            pnl2.add(this.txtDelimiter);
            this.txtDelimiter.setEditable(false);
            this.txtDelimiter.setEnabled(false);
            JPanel pnl3 = new JPanel(new GridLayout(2, 1));
            pnl3.add(pnl1);
            pnl3.add(pnl2);
            JPanel pnl4 = new JPanel(new FlowLayout(0));
            this.setComponentCenter(pnl4);
            pnl4.add(pnl3);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbTab);
            bg.add(this.rbOther);
            this.rbTab.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TxtChoice.this.txtDelimiter.setEditable(!TxtChoice.this.rbTab.isSelected());
                    TxtChoice.this.txtDelimiter.setEnabled(!TxtChoice.this.rbTab.isSelected());
                }
            });
        }

        private String getDelimiter() {
            if (this.rbTab.isSelected()) {
                return "\t";
            }
            return this.txtDelimiter.getText();
        }

        @Override
        int open() {
            int bytes = super.open();
            if (this.cbxHeader.isSelected()) {
                String line = this.nextln();
                bytes -= line.length() + 1;
            }
            return bytes;
        }

        @Override
        void flush(String line, Object[] rowdata) {
            String value;
            Vector<String> vRow = new Vector<String>();
            int bix = 0;
            int eix = 0;
            while ((eix = line.indexOf(this.getDelimiter(), bix)) != -1) {
                value = line.substring(bix, eix);
                bix = eix + this.getDelimiter().length();
                if (this.cbxNull.isSelected() && value.trim().length() == 0) {
                    value = null;
                }
                if (this.cbxTrim.isSelected() && value != null) {
                    value = value.trim();
                }
                vRow.addElement(value);
            }
            if (bix < line.length() - 1) {
                value = line.substring(bix);
                if (this.cbxNull.isSelected() && value.trim().length() == 0) {
                    value = null;
                }
                if (this.cbxTrim.isSelected() && value != null) {
                    value = value.trim();
                }
                vRow.addElement(value);
            }
            vRow.toArray(rowdata);
        }
    }

    private abstract class AbstractChoice
    extends BorderLayoutPanel {
        private FileInputStream stream;
        JRadioButton rbAll;
        JRadioButton rbUser;
        JTextField txtInterval;

        AbstractChoice() {
            this.setBorder(new TitledBorder("options"));
        }

        int open() {
            try {
                this.stream = new FileInputStream(MaskImport.this.lblFile.getText().substring(6));
                return this.stream.available();
            }
            catch (FileNotFoundException e) {
                Application.println(e, true);
            }
            catch (IOException e) {
                Application.println(e, true);
            }
            return 0;
        }

        void close() {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                Application.println(e, true);
            }
        }

        abstract void flush(String var1, Object[] var2);

        String nextln() {
            try {
                int nChar;
                String line = new String("");
                while ((nChar = this.stream.read()) != -1 && (char)nChar != '\n') {
                    line = line + (char)nChar;
                }
                return line;
            }
            catch (IOException e) {
                Application.println(e, true);
                return null;
            }
        }
    }
}

