/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.AbstractMaskPerform;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;

public class MaskExport
extends AbstractMaskPerform {
    private AbstractChoice eChoice;

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.eChoice.getComponentCount(); ++i) {
            this.eChoice.getComponent(i).setEnabled(b);
        }
    }

    @Override
    void setType(short type, String tname, String fname) {
        if (this.eChoice != null) {
            this.remove(this.eChoice);
        }
        this.progress.setValue(0);
        this.progress.setMaximum(0);
        if (type == 2) {
            if (!fname.endsWith(".htm") && !fname.endsWith(".html")) {
                fname = fname + ".html";
            }
            this.eChoice = new WebChoice();
            this.setComponentCenter(this.eChoice);
        } else if (type == 0) {
            if (!fname.endsWith(".sql")) {
                fname = fname + ".sql";
            }
            this.eChoice = new SqlChoice(tname);
            this.setComponentCenter(this.eChoice);
        } else if (type == 1) {
            if (!fname.endsWith(".txt")) {
                fname = fname + ".txt";
            }
            this.eChoice = new TxtChoice();
            this.setComponentCenter(this.eChoice);
        }
        this.lblFile.setText("file: " + fname);
    }

    @Override
    void init() {
        super.init();
        this.progress.setValue(0);
        this.progress.setMaximum(this.eChoice.getLastRow() - this.eChoice.getFirstRow() + 1);
        this.eChoice.open();
    }

    @Override
    void next() {
        this.eChoice.handle(this.view.getValues(this.progress.getValue() + this.eChoice.getFirstRow() - 1));
        this.progress.setValue(this.progress.getValue() + 1);
    }

    @Override
    boolean finished() {
        if (this.progress.getValue() == this.progress.getMaximum()) {
            this.eChoice.close();
            this.btnStop.setEnabled(false);
            this.lblMsg.setText("ready!");
            return true;
        }
        return false;
    }

    private class TxtChoice
    extends AbstractChoice {
        JCheckBox cbxHeader;
        JCheckBox cbxNull;
        JCheckBox cbxTrim;
        JRadioButton rbTab;
        JRadioButton rbOther;
        JTextField txtDelimiter;

        private TxtChoice() {
        }

        @Override
        void initComponents() {
            JPanel pnl1 = new JPanel(new FlowLayout(0));
            this.cbxHeader = new JCheckBox("with header");
            pnl1.add(this.cbxHeader);
            this.cbxNull = new JCheckBox("null if blanks");
            pnl1.add(this.cbxNull);
            this.cbxTrim = new JCheckBox("trim value");
            pnl1.add(this.cbxTrim);
            JPanel pnl2 = new JPanel(new FlowLayout(0));
            pnl2.add(new JLabel("delimiter:"));
            this.rbTab = new JRadioButton("tab", true);
            pnl2.add(this.rbTab);
            this.rbOther = new JRadioButton("other");
            pnl2.add(this.rbOther);
            this.txtDelimiter = new JTextField(";", 5);
            pnl2.add(this.txtDelimiter);
            this.txtDelimiter.setEditable(false);
            this.txtDelimiter.setEnabled(false);
            JPanel pnl3 = new JPanel(new GridLayout(2, 1));
            pnl3.add(pnl1);
            pnl3.add(pnl2);
            JPanel pnl4 = new JPanel(new FlowLayout(0));
            this.setComponentCenter(pnl4);
            pnl4.add(pnl3);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbTab);
            bg.add(this.rbOther);
            this.rbTab.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TxtChoice.this.txtDelimiter.setEditable(!TxtChoice.this.rbTab.isSelected());
                    TxtChoice.this.txtDelimiter.setEnabled(!TxtChoice.this.rbTab.isSelected());
                }
            });
            super.initComponents();
        }

        private String getDelimiter() {
            if (this.rbTab.isSelected()) {
                return "\t";
            }
            return this.txtDelimiter.getText();
        }

        @Override
        void open() {
            super.open();
            if (this.cbxHeader.isSelected()) {
                StringBuffer buffer = new StringBuffer();
                for (int col = 0; col < MaskExport.this.view.getColumnCount(); ++col) {
                    buffer.append(MaskExport.this.view.getColumnName(col) + this.getDelimiter());
                }
                if (buffer.length() > 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                this.println(buffer.toString());
            }
        }

        @Override
        void handle(Object[] vals) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i] == null ? "null" : vals[i].toString();
                buffer.append(val + this.getDelimiter());
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            this.println(buffer.toString());
        }
    }

    private class SqlChoice
    extends AbstractChoice {
        JCheckBox cbxDelete;
        JTextField txtTable;
        String insert;

        SqlChoice(String tname) {
            this.insert = null;
            this.txtTable.setText(tname);
        }

        @Override
        void initComponents() {
            JPanel pnl1 = new JPanel(new FlowLayout(0));
            pnl1.add(new JLabel("table name:"));
            this.txtTable = new JTextField(10);
            pnl1.add(this.txtTable);
            this.cbxDelete = new JCheckBox("with delete statement");
            JPanel pnl2 = new JPanel(new GridLayout(2, 1));
            pnl2.add(pnl1);
            pnl2.add(this.cbxDelete);
            JPanel pnl3 = new JPanel(new FlowLayout(0));
            this.setComponentCenter(pnl3);
            pnl3.add(pnl2);
            super.initComponents();
        }

        @Override
        void open() {
            super.open();
            if (this.cbxDelete.isSelected()) {
                this.println("DELETE FROM " + this.txtTable.getText() + ";");
            }
            StringBuffer buffer = new StringBuffer("INSERT INTO " + this.txtTable.getText() + " (");
            for (int col = 0; col < MaskExport.this.view.getColumnCount(); ++col) {
                buffer.append(MaskExport.this.view.getColumnName(col) + ",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.insert = buffer.toString() + ")";
        }

        @Override
        void handle(Object[] vals) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                buffer.append(this.toSQLValue(vals[i], i) + ",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.println(this.insert + " VALUES (" + buffer.toString() + ");");
        }

        private String toSQLValue(Object value, int col) {
            if (value == null) {
                return "null";
            }
            switch (MaskExport.this.view.getColumnType(col)) {
                case 1: 
                case 12: {
                    value = Text.replaceText(value.toString(), "'", "\\'");
                    return "'" + value.toString() + "'";
                }
                case 91: {
                    return "{d '" + value.toString() + "'}";
                }
                case 92: {
                    return "{t '" + value.toString() + "'}";
                }
                case 93: {
                    return "{ts '" + value.toString() + "'}";
                }
            }
            return value.toString();
        }
    }

    private class WebChoice
    extends AbstractChoice {
        JCheckBox cbxHeader;

        private WebChoice() {
        }

        @Override
        void initComponents() {
            JPanel pnl = new JPanel(new FlowLayout(0));
            this.cbxHeader = new JCheckBox("with header");
            pnl.add(this.cbxHeader);
            this.setComponentCenter(pnl);
            super.initComponents();
        }

        @Override
        void open() {
            super.open();
            this.println("<html><body><table border=1>");
            if (this.cbxHeader.isSelected()) {
                this.print("<tr>");
                for (int col = 0; col < MaskExport.this.view.getColumnCount(); ++col) {
                    this.print("<th>" + MaskExport.this.view.getColumnName(col) + "</th>");
                }
                this.println("</tr>");
            }
        }

        @Override
        void handle(Object[] vals) {
            this.print("<tr>");
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i] == null ? "null" : vals[i].toString();
                this.print("<td>" + val + "</td>");
            }
            this.println("</tr>");
        }

        @Override
        void close() {
            this.println("</table></body></html>");
            super.close();
        }
    }

    private abstract class AbstractChoice
    extends BorderLayoutPanel {
        private PrintStream stream;
        JRadioButton rbAll;
        JRadioButton rbBlock;
        JRadioButton rbUser;
        JTextField txtInterval;

        AbstractChoice() {
            this.setBorder(new TitledBorder("options"));
            this.initComponents();
        }

        void initComponents() {
            JPanel pnl = new JPanel(new FlowLayout(0));
            this.setComponentSouth(pnl);
            pnl.add(new JLabel("records:"));
            this.rbAll = new JRadioButton("all", true);
            pnl.add(this.rbAll);
            this.rbBlock = new JRadioButton("current block");
            pnl.add(this.rbBlock);
            this.rbUser = new JRadioButton("define:");
            pnl.add(this.rbUser);
            this.txtInterval = new JTextField("1..", 8);
            pnl.add(this.txtInterval);
            this.txtInterval.setEditable(false);
            this.txtInterval.setEnabled(false);
            ButtonGroup bg = new ButtonGroup();
            ItemListener il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AbstractChoice.this.txtInterval.setEditable(AbstractChoice.this.rbUser.isSelected());
                    AbstractChoice.this.txtInterval.setEnabled(AbstractChoice.this.rbUser.isSelected());
                    if (AbstractChoice.this.rbAll.isSelected()) {
                        AbstractChoice.this.txtInterval.setText("1..");
                    } else if (AbstractChoice.this.rbBlock.isSelected()) {
                        int last = MaskExport.this.view.getBlock() * ContentModel.MAX_BLOCK_RECORDS;
                        int first = last - ContentModel.MAX_BLOCK_RECORDS;
                        if (first == 0) {
                            first = 1;
                        }
                        if (last > MaskExport.this.view.getFlatRowCount()) {
                            last = MaskExport.this.view.getFlatRowCount() - 1;
                        }
                        AbstractChoice.this.txtInterval.setText(first + ".." + last);
                    }
                }
            };
            bg.add(this.rbAll);
            bg.add(this.rbBlock);
            bg.add(this.rbUser);
            this.rbAll.addItemListener(il);
            this.rbBlock.addItemListener(il);
            this.rbUser.addItemListener(il);
        }

        int getFirstRow() {
            String interval = ((MaskExport)MaskExport.this).eChoice.txtInterval.getText();
            int pos = interval.indexOf("..");
            return Integer.valueOf(interval.substring(0, pos));
        }

        int getLastRow() {
            String interval = ((MaskExport)MaskExport.this).eChoice.txtInterval.getText();
            int pos = interval.indexOf("..") + 2;
            return pos < interval.length() ? Integer.valueOf(interval.substring(pos)).intValue() : MaskExport.this.view.getFlatRowCount();
        }

        void open() {
            try {
                this.stream = new PrintStream(new FileOutputStream(MaskExport.this.lblFile.getText().substring(6)));
            }
            catch (FileNotFoundException e) {
                Application.println(e, true);
            }
        }

        abstract void handle(Object[] var1);

        void close() {
            this.stream.close();
        }

        void print(String s) {
            this.stream.print(s);
        }

        void println(String s) {
            this.stream.println(s);
        }
    }
}

