/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import javax.swing.JCheckBox;
import nickyb.sqleonardo.common.gui.AbstractDialogWizard;
import nickyb.sqleonardo.common.gui.AbstractMaskChooser;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.AbstractMaskPerform;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;
import nickyb.sqleonardo.environment.ctrl.content.MaskExport;
import nickyb.sqleonardo.environment.ctrl.content.MaskImport;
import nickyb.sqleonardo.environment.mdi.DefaultMaskChooser;

public class DialogStream
extends AbstractDialogWizard {
    private String tname = null;
    private ContentView view;
    private JCheckBox cbxClose;
    private AbstractMaskPerform mkp;
    private AbstractMaskChooser mkc;
    private TaskOwner task;

    private DialogStream(String title, ContentView view, String tname) {
        super((Component)Application.window, title);
        this.tname = tname;
        this.view = view;
        this.cbxClose = new JCheckBox("close dialog when finished", Preferences.getBoolean("content.close-dialog", false));
        this.cbxClose.setVisible(false);
        this.bar.add((Component)this.cbxClose, 0);
    }

    public static void showExport(ContentPane content) {
        String tname = null;
        new DialogStream("export", content.getView(), tname).setVisible(true);
    }

    public static void showImport(ContentPane content) {
        String tname = null;
        new DialogStream("import", content.getView(), tname).setVisible(true);
    }

    @Override
    public void dispose() {
        Preferences.set("content.close-dialog", new Boolean(this.cbxClose.isSelected()));
        super.dispose();
    }

    @Override
    protected boolean onBack() {
        this.cbxClose.setVisible(false);
        return super.onBack();
    }

    @Override
    protected boolean onNext() {
        this.cbxClose.setVisible(true);
        if (this.getStep() == 0) {
            if (this.mkc.getSelectedFile() != null) {
                this.mkp.setType(this.mkc.getPerformType(), this.tname, this.mkc.getSelectedFile().toString());
                this.mkp.setContent(this.view);
                return true;
            }
        } else {
            this.task = new TaskOwner();
            new Thread(this.task).start();
        }
        return false;
    }

    @Override
    protected void onOpen() {
        if (this.getTitle().equals("export")) {
            this.mkp = new MaskExport();
            this.mkc = new DefaultMaskChooser(1, 0, false);
            this.mkc.addChoosableFileFilter(new SQLFilter());
            this.mkc.addChoosableFileFilter(new WebFilter());
        } else if (this.getTitle().equals("import")) {
            this.mkp = new MaskImport();
            this.mkc = new DefaultMaskChooser(0, 0, false);
        }
        this.mkc.addChoosableFileFilter(new TXTFilter());
        this.addStep(this.mkc);
        this.addStep(this.mkp);
        this.getContentPane().validate();
    }

    private static class WebFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        WebFilter() {
            super("web pages", new String[]{".htm", ".html"});
        }

        @Override
        public short getPerformType() {
            return 2;
        }
    }

    private static class TXTFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        TXTFilter() {
            super("text files", new String[]{".txt"});
        }

        @Override
        public short getPerformType() {
            return 1;
        }
    }

    private static class SQLFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        SQLFilter() {
            super("insert statements", new String[]{".sql"});
        }

        @Override
        public short getPerformType() {
            return 0;
        }
    }

    private class TaskOwner
    implements Runnable {
        private TaskOwner() {
        }

        @Override
        public void run() {
            DialogStream.this.setBarEnabled(false);
            DialogStream.this.mkp.setEnabled(false);
            DialogStream.this.mkp.init();
            while (DialogStream.this.task != null && !DialogStream.this.mkp.aborted() && !DialogStream.this.mkp.finished()) {
                DialogStream.this.mkp.next();
            }
            DialogStream.this.mkp.setEnabled(true);
            DialogStream.this.setBarEnabled(true);
            if (DialogStream.this.mkp.finished() && DialogStream.this.cbxClose.isSelected()) {
                DialogStream.this.dispose();
            }
        }
    }
}

