/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl;

import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.define.ColumnsChooser;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DefinitionPane
extends BorderLayoutPanel
implements ChangeListener {
    private ListView lvColumns;
    private ListView lvPrimaryKeys;
    private ListView lvIndexInfo;
    private ListView lvExportedKeys;
    private ListView lvImportedKeys;
    private JTabbedPane tp;
    private String keycah;
    private QueryTokens.Table table;

    public DefinitionPane(String keycah, QueryTokens.Table table) {
        this.keycah = keycah;
        this.table = table;
        this.tp = new JTabbedPane();
        this.tp.addChangeListener(this);
        this.tp.setBorder(LineBorder.createGrayLineBorder());
        this.lvColumns = new ListView();
        this.tp.addTab("columns", this.lvColumns);
        this.lvPrimaryKeys = new ListView();
        this.tp.addTab("primary keys", this.lvPrimaryKeys);
        this.lvIndexInfo = new ListView();
        this.tp.addTab("indices", this.lvIndexInfo);
        this.lvExportedKeys = new ListView();
        this.tp.addTab("exported keys", this.lvExportedKeys);
        this.lvImportedKeys = new ListView();
        this.tp.addTab("imported keys", this.lvImportedKeys);
        this.setComponentCenter(this.tp);
    }

    private ConnectionHandler getConnection() {
        return ConnectionAssistant.getHandler(this.keycah);
    }

    private void list(String metaview, ListView lv, ResultSet rs) throws SQLException {
        int i = this.keycah.lastIndexOf(46);
        ColumnsChooser.list(this.keycah.substring(0, i), metaview, lv, rs);
    }

    private void listColumns() throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getColumns(catalog, this.table.getSchema(), this.table.getName(), "%");
        this.list("columns", this.lvColumns, rs);
        this.tp.setTitleAt(0, "columns (" + this.lvColumns.getRowCount() + ")");
    }

    private void listPrimaryKeys() throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getPrimaryKeys(catalog, this.table.getSchema(), this.table.getName());
        this.list("primary keys", this.lvPrimaryKeys, rs);
        this.tp.setTitleAt(1, "primary keys (" + this.lvPrimaryKeys.getRowCount() + ")");
    }

    private void listIndexInfo() throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getIndexInfo(catalog, this.table.getSchema(), this.table.getName(), false, false);
        this.list("indices", this.lvIndexInfo, rs);
        this.tp.setTitleAt(2, "indices (" + this.lvIndexInfo.getRowCount() + ")");
    }

    private void listExportedKeys() throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getExportedKeys(catalog, this.table.getSchema(), this.table.getName());
        this.list("exported keys", this.lvExportedKeys, rs);
        this.tp.setTitleAt(3, "exported keys (" + this.lvExportedKeys.getRowCount() + ")");
    }

    private void listImportedKeys() throws SQLException {
        ConnectionHandler ch = this.getConnection();
        String catalog = this.table.getSchema() == null ? null : ch.get().getCatalog();
        ResultSet rs = ch.get().getMetaData().getImportedKeys(catalog, this.table.getSchema(), this.table.getName());
        this.list("imported keys", this.lvImportedKeys, rs);
        this.tp.setTitleAt(4, "imported keys (" + this.lvImportedKeys.getRowCount() + ")");
    }

    public String getSelectedTitle() {
        int idx = this.tp.getSelectedIndex();
        if (this.tp.getTitleAt(idx).endsWith(")")) {
            String title = this.tp.getTitleAt(idx);
            return title.substring(0, title.indexOf(" ("));
        }
        return this.tp.getTitleAt(idx);
    }

    public ListView getSelectedView() {
        return this.getViewAt(this.tp.getSelectedIndex());
    }

    public ListView getViewAt(int idx) {
        return (ListView)this.tp.getComponentAt(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stateChanged(ChangeEvent ce) {
        int idx = this.tp.getSelectedIndex();
        if (this.getSelectedView().getColumnCount() > 0) return;
        if (this.tp.getTitleAt(idx).indexOf(33) != -1) {
            return;
        }
        try {
            this.setCursor(new Cursor(3));
            switch (idx) {
                case 0: {
                    this.listColumns();
                    return;
                }
                case 1: {
                    this.listPrimaryKeys();
                    return;
                }
                case 2: {
                    this.listIndexInfo();
                    return;
                }
                case 3: {
                    this.listExportedKeys();
                    return;
                }
                case 4: {
                    this.listImportedKeys();
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            this.tp.setTitleAt(idx, this.getSelectedTitle() + " (!)");
            Application.println(e, true);
            return;
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }
}

