/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.CpfProperties;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public abstract class AbstractCpfProperties
extends Properties {
    protected static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(CpfProperties.class);
    protected static String PROPERTIES_FILE = "config.properties";

    protected AbstractCpfProperties(IContentAccessFactory accessor) {
        this.loadSettings(accessor);
    }

    protected boolean loadProperties(IReadAccess location, String fileName) throws IOException {
        if (location.fileExists(fileName)) {
            this.loadAndClose(location.getFileInputStream(fileName));
            return true;
        }
        return false;
    }

    protected void loadSettings(IContentAccessFactory accessor) {
        try {
            IReadAccess inSystem;
            IReadAccess inRepositoryCpf;
            if (!this.loadClassProperties(PROPERTIES_FILE)) {
                logger.warn((Object)"No CPF base settings.");
            }
            if (!this.loadAsSystem(inRepositoryCpf = accessor.getPluginRepositoryReader("../cpf")) && logger.isDebugEnabled()) {
                logger.debug((Object)"No global CPF settings.");
            }
            if (!this.loadProperties(inSystem = PluginEnvironment.repository().getPluginSystemReader(""), PROPERTIES_FILE) && logger.isDebugEnabled()) {
                logger.debug((Object)"No plugin-specific CPF settings.");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Failed to read CPF settings", (Throwable)ioe);
        }
    }

    protected boolean loadClassProperties(String fileName) throws IOException {
        InputStream file = this.getClass().getResourceAsStream(fileName);
        if (file != null) {
            this.loadAndClose(file);
            return true;
        }
        return false;
    }

    public boolean getBooleanProperty(String property, boolean defaultValue) {
        String propertyValue = this.getProperty(property, null);
        if (!StringUtils.isEmpty((String)propertyValue)) {
            return Boolean.parseBoolean(propertyValue);
        }
        return defaultValue;
    }

    public int getIntProperty(String property, int defaultValue) {
        String propertyValue = this.getProperty(property, null);
        if (!StringUtils.isEmpty((String)propertyValue)) {
            try {
                return Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("getIntProperty: " + property + " is not a valid int value."));
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String property, long defaultValue) {
        String propertyValue = this.getProperty(property, null);
        if (!StringUtils.isEmpty((String)propertyValue)) {
            try {
                return Long.parseLong(propertyValue);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("getLongProperty: " + property + " is not a valid long value."));
            }
        }
        return defaultValue;
    }

    protected void loadAndClose(InputStream input) throws IOException {
        try {
            this.load(input);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    protected abstract boolean loadAsSystem(IReadAccess var1);
}

