/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.io;

import java.io.IOException;
import java.io.OutputStream;

public class BandwidthControlledOutputStream
extends OutputStream {
    private int bandwidth = 512;
    private OutputStream out;
    private static int SLEEP_TIME = 1000;
    private int bytesWritten;

    public BandwidthControlledOutputStream(OutputStream out, int bandwidth) {
        if (bandwidth > this.bandwidth) {
            this.bandwidth = bandwidth;
        }
        this.out = out;
    }

    public void write(int b) throws IOException {
        ++this.bytesWritten;
        this.out.write(b);
        this.sleep();
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        int position = off;
        int capacity = len;
        while (position < capacity) {
            int bytes2write = capacity - position > this.bandwidth ? this.bandwidth : capacity - position;
            this.out.write(bytes, position, bytes2write);
            position += bytes2write;
            this.bytesWritten += bytes2write;
            this.sleep();
        }
    }

    private void sleep() {
        if (this.bytesWritten >= this.bandwidth) {
            try {
                Thread.sleep(SLEEP_TIME);
                this.bytesWritten = 0;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

