/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptSchemaWithSampling;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlScopedShuttle;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlValidatorUtil {
    public static final Suggester EXPR_SUGGESTER = new Suggester(){

        public String apply(String original, int attempt, int size) {
            return Util.first(original, "EXPR$") + attempt;
        }
    };
    public static final Suggester F_SUGGESTER = new Suggester(){

        public String apply(String original, int attempt, int size) {
            return Util.first(original, "$f") + Math.max(size, attempt);
        }
    };

    private SqlValidatorUtil() {
    }

    public static RelOptTable getRelOptTable(SqlValidatorNamespace namespace, Prepare.CatalogReader catalogReader, String datasetName, boolean[] usedDataset) {
        RelOptTable table;
        if (!namespace.isWrapperFor(TableNamespace.class)) {
            return null;
        }
        TableNamespace tableNamespace = namespace.unwrap(TableNamespace.class);
        List<String> names = tableNamespace.getTable().getQualifiedName();
        if (datasetName != null && catalogReader instanceof RelOptSchemaWithSampling) {
            RelOptSchemaWithSampling reader = (RelOptSchemaWithSampling)((Object)catalogReader);
            table = reader.getTableForMember(names, datasetName, usedDataset);
        } else {
            table = catalogReader.getTableForMember(names);
        }
        if (!tableNamespace.extendedFields.isEmpty()) {
            table = table.extend((List<RelDataTypeField>)tableNamespace.extendedFields);
        }
        return table;
    }

    public static RelDataTypeField lookupField(boolean caseSensitive, boolean elideRecord, RelDataType rowType, String columnName) {
        return rowType.getField(columnName, caseSensitive, elideRecord);
    }

    public static void checkCharsetAndCollateConsistentIfCharType(RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset strCharset = type.getCharset();
            Charset colCharset = type.getCollation().getCharset();
            assert (null != strCharset);
            assert (null != colCharset);
            if (!strCharset.equals(colCharset)) {
                // empty if block
            }
        }
    }

    public static SqlNode addAlias(SqlNode expr, String alias) {
        SqlParserPos pos = expr.getParserPosition();
        SqlIdentifier id = new SqlIdentifier(alias, pos);
        return SqlStdOperatorTable.AS.createCall(pos, expr, id);
    }

    public static String getAlias(SqlNode node, int ordinal) {
        switch (node.getKind()) {
            case AS: {
                return ((SqlNode)((SqlCall)node).operand(1)).toString();
            }
            case OVER: {
                return SqlValidatorUtil.getAlias(((SqlCall)node).operand(0), ordinal);
            }
            case IDENTIFIER: {
                return Util.last(((SqlIdentifier)node).names);
            }
        }
        if (ordinal < 0) {
            return null;
        }
        return SqlUtil.deriveAliasFromOrdinal(ordinal);
    }

    public static String uniquify(String name, Set<String> nameList, Suggester suggester) {
        if (name != null && nameList.add(name)) {
            return name;
        }
        String originalName = name;
        int j = 0;
        while (!nameList.add(name = suggester.apply(originalName, j, nameList.size()))) {
            ++j;
        }
        return name;
    }

    public static SqlValidatorWithHints newValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
        return new SqlValidatorImpl(opTab, catalogReader, typeFactory, SqlConformance.DEFAULT);
    }

    public static List<String> uniquify(List<String> nameList) {
        return SqlValidatorUtil.uniquify(nameList, EXPR_SUGGESTER);
    }

    public static List<String> uniquify(List<String> nameList, Suggester suggester) {
        LinkedHashSet<String> used = new LinkedHashSet<String>();
        int changeCount = 0;
        for (String name : nameList) {
            String uniqueName = SqlValidatorUtil.uniquify(name, used, suggester);
            if (uniqueName.equals(name)) continue;
            ++changeCount;
        }
        return changeCount == 0 ? nameList : new ArrayList(used);
    }

    public static SqlValidatorNamespace lookup(SqlValidatorScope scope, List<String> names) {
        assert (names.size() > 0);
        SqlValidatorNamespace namespace = null;
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            namespace = i == 0 ? scope.resolve((List<String>)ImmutableList.of((Object)name), null, null) : namespace.lookupChild(name);
        }
        assert (namespace != null);
        return namespace;
    }

    public static void getSchemaObjectMonikers(SqlValidatorCatalogReader catalogReader, List<String> names, List<SqlMoniker> hints) {
        List<String> subNames = Util.skipLast(names);
        List<String> x = catalogReader.getSchemaName();
        while (true) {
            ImmutableList names2 = ImmutableList.builder().addAll(x).addAll(subNames).build();
            hints.addAll(catalogReader.getAllSchemaObjectNames((List<String>)names2));
            if (x.isEmpty()) break;
            x = Util.skipLast(x);
        }
    }

    public static SelectScope getEnclosingSelectScope(SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof SelectScope) {
                return (SelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static AggregatingSelectScope getEnclosingAggregateSelectScope(SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof AggregatingSelectScope) {
                return (AggregatingSelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static List<String> deriveNaturalJoinColumnList(RelDataType leftRowType, RelDataType rightRowType) {
        ArrayList<String> naturalColumnNames = new ArrayList<String>();
        List<String> leftNames = leftRowType.getFieldNames();
        List<String> rightNames = rightRowType.getFieldNames();
        for (String name : leftNames) {
            if (Collections.frequency(leftNames, name) != 1 || Collections.frequency(rightNames, name) != 1) continue;
            naturalColumnNames.add(name);
        }
        return naturalColumnNames;
    }

    public static RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList, RelDataTypeFactory typeFactory, boolean caseSensitive, boolean elideRecord) {
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>(columnNameList.size());
        for (String name : columnNameList) {
            RelDataTypeField field = type.getField(name, caseSensitive, elideRecord);
            fields.add(type.getFieldList().get(field.getIndex()));
        }
        return typeFactory.createStructType(fields);
    }

    public static void analyzeGroupItem(SqlValidatorScope scope, List<SqlNode> groupExprs, Map<Integer, Integer> groupExprProjection, ImmutableList.Builder<ImmutableList<ImmutableBitSet>> topBuilder, SqlNode groupExpr) {
        switch (groupExpr.getKind()) {
            case ROLLUP: 
            case CUBE: {
                List<ImmutableBitSet> bitSets = SqlValidatorUtil.analyzeGroupTuple(scope, groupExprs, groupExprProjection, ((SqlCall)groupExpr).getOperandList());
                switch (groupExpr.getKind()) {
                    case ROLLUP: {
                        topBuilder.add(SqlValidatorUtil.rollup(bitSets));
                        return;
                    }
                }
                topBuilder.add(SqlValidatorUtil.cube(bitSets));
                return;
            }
            case OTHER: {
                if (!(groupExpr instanceof SqlNodeList)) break;
                SqlNodeList list = (SqlNodeList)groupExpr;
                for (SqlNode node : list) {
                    SqlValidatorUtil.analyzeGroupItem(scope, groupExprs, groupExprProjection, topBuilder, node);
                }
                return;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        SqlValidatorUtil.convertGroupSet(scope, groupExprs, groupExprProjection, (ImmutableList.Builder<ImmutableBitSet>)builder, groupExpr);
        topBuilder.add((Object)builder.build());
    }

    private static void convertGroupSet(SqlValidatorScope scope, List<SqlNode> groupExprs, Map<Integer, Integer> groupExprProjection, ImmutableList.Builder<ImmutableBitSet> builder, SqlNode groupExpr) {
        switch (groupExpr.getKind()) {
            case GROUPING_SETS: {
                SqlCall call = (SqlCall)groupExpr;
                for (SqlNode node : call.getOperandList()) {
                    SqlValidatorUtil.convertGroupSet(scope, groupExprs, groupExprProjection, builder, node);
                }
                return;
            }
            case ROW: {
                List<ImmutableBitSet> bitSets = SqlValidatorUtil.analyzeGroupTuple(scope, groupExprs, groupExprProjection, ((SqlCall)groupExpr).getOperandList());
                builder.add((Object)ImmutableBitSet.union(bitSets));
                return;
            }
        }
        builder.add((Object)SqlValidatorUtil.analyzeGroupExpr(scope, groupExprs, groupExprProjection, groupExpr));
    }

    private static List<ImmutableBitSet> analyzeGroupTuple(SqlValidatorScope scope, List<SqlNode> groupExprs, Map<Integer, Integer> groupExprProjection, List<SqlNode> operandList) {
        ArrayList list = Lists.newArrayList();
        for (SqlNode operand : operandList) {
            list.add(SqlValidatorUtil.analyzeGroupExpr(scope, groupExprs, groupExprProjection, operand));
        }
        return list;
    }

    private static ImmutableBitSet analyzeGroupExpr(SqlValidatorScope scope, List<SqlNode> groupExprs, Map<Integer, Integer> groupExprProjection, SqlNode groupExpr) {
        SqlNode expandedGroupExpr = scope.getValidator().expand(groupExpr, scope);
        switch (expandedGroupExpr.getKind()) {
            case ROW: {
                return ImmutableBitSet.union(SqlValidatorUtil.analyzeGroupTuple(scope, groupExprs, groupExprProjection, ((SqlCall)expandedGroupExpr).getOperandList()));
            }
            case OTHER: {
                if (!(expandedGroupExpr instanceof SqlNodeList) || ((SqlNodeList)expandedGroupExpr).size() != 0) break;
                return ImmutableBitSet.of();
            }
        }
        int ref = SqlValidatorUtil.lookupGroupExpr(groupExprs, groupExpr);
        if (expandedGroupExpr instanceof SqlIdentifier) {
            SqlIdentifier expr = (SqlIdentifier)expandedGroupExpr;
            assert (expr.names.size() == 2);
            String originalRelName = (String)expr.names.get(0);
            String originalFieldName = (String)expr.names.get(1);
            int[] nsIndexes = new int[]{-1};
            SqlValidatorScope[] ancestorScopes = new SqlValidatorScope[]{null};
            SqlValidatorNamespace foundNs = scope.resolve((List<String>)ImmutableList.of((Object)originalRelName), ancestorScopes, nsIndexes);
            assert (foundNs != null);
            assert (nsIndexes.length == 1);
            int childNamespaceIndex = nsIndexes[0];
            int namespaceOffset = 0;
            if (childNamespaceIndex > 0) {
                assert (ancestorScopes[0] instanceof ListScope);
                List<SqlValidatorNamespace> children = ((ListScope)ancestorScopes[0]).getChildren();
                for (int j = 0; j < childNamespaceIndex; ++j) {
                    namespaceOffset += children.get(j).getRowType().getFieldCount();
                }
            }
            RelDataTypeField field = scope.getValidator().getCatalogReader().field(foundNs.getRowType(), originalFieldName);
            int origPos = namespaceOffset + field.getIndex();
            groupExprProjection.put(origPos, ref);
        }
        return ImmutableBitSet.of(ref);
    }

    private static int lookupGroupExpr(List<SqlNode> groupExprs, SqlNode expr) {
        for (Ord node : Ord.zip(groupExprs)) {
            if (!((SqlNode)node.e).equalsDeep(expr, false)) continue;
            return node.i;
        }
        groupExprs.add(expr);
        return groupExprs.size() - 1;
    }

    @VisibleForTesting
    public static ImmutableList<ImmutableBitSet> rollup(List<ImmutableBitSet> bitSets) {
        LinkedHashSet builder = Sets.newLinkedHashSet();
        while (true) {
            ImmutableBitSet union = ImmutableBitSet.union(bitSets);
            builder.add(union);
            if (union.isEmpty()) break;
            bitSets = bitSets.subList(0, bitSets.size() - 1);
        }
        return ImmutableList.copyOf((Collection)builder);
    }

    @VisibleForTesting
    public static ImmutableList<ImmutableBitSet> cube(List<ImmutableBitSet> bitSets) {
        LinkedHashSet builder = Sets.newLinkedHashSet();
        for (ImmutableBitSet bitSet : bitSets) {
            builder.add(Arrays.asList(bitSet, ImmutableBitSet.of()));
        }
        LinkedHashSet flattenedBitSets = Sets.newLinkedHashSet();
        for (List o : Linq4j.product((Iterable)builder)) {
            flattenedBitSets.add(ImmutableBitSet.union(o));
        }
        return ImmutableList.copyOf((Collection)flattenedBitSets);
    }

    static interface Suggester {
        public String apply(String var1, int var2, int var3);
    }

    public static class DeepCopier
    extends SqlScopedShuttle {
        DeepCopier(SqlValidatorScope scope) {
            super(scope);
        }

        public static SqlNodeList copy(SqlValidatorScope scope, SqlNodeList list) {
            return (SqlNodeList)list.accept(new DeepCopier(scope));
        }

        public SqlNode visit(SqlNodeList list) {
            SqlNodeList copy = new SqlNodeList(list.getParserPosition());
            for (SqlNode node : list) {
                copy.add(node.accept(this));
            }
            return copy;
        }

        protected SqlNode visitScoped(SqlCall call) {
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, true);
            call.getOperator().acceptCall(this, call, false, argHandler);
            return (SqlNode)argHandler.result();
        }

        public SqlNode visit(SqlLiteral literal) {
            return (SqlNode)literal.clone();
        }

        public SqlNode visit(SqlIdentifier id) {
            return this.getScope().fullyQualify((SqlIdentifier)id).identifier;
        }

        public SqlNode visit(SqlDataTypeSpec type) {
            return (SqlNode)type.clone();
        }

        public SqlNode visit(SqlDynamicParam param) {
            return (SqlNode)param.clone();
        }

        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return (SqlNode)intervalQualifier.clone();
        }
    }
}

