/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;

public class SemiJoinJoinTransposeRule
extends RelOptRule {
    public static final SemiJoinJoinTransposeRule INSTANCE = new SemiJoinJoinTransposeRule();

    private SemiJoinJoinTransposeRule() {
        super(SemiJoinJoinTransposeRule.operand(SemiJoin.class, SemiJoinJoinTransposeRule.some(SemiJoinJoinTransposeRule.operand(Join.class, SemiJoinJoinTransposeRule.any()), new RelOptRuleOperand[0])));
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinRel;
        RelNode leftJoinRel;
        List<Integer> newLeftKeys;
        RexNode newSemiJoinFilter;
        int i;
        SemiJoin semiJoin = (SemiJoin)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        ImmutableIntList leftKeys = semiJoin.getLeftKeys();
        ImmutableIntList rightKeys = semiJoin.getRightKeys();
        int nFieldsX = join.getLeft().getRowType().getFieldList().size();
        int nFieldsY = join.getRight().getRowType().getFieldList().size();
        int nFieldsZ = semiJoin.getRight().getRowType().getFieldList().size();
        int nTotalFields = nFieldsX + nFieldsY + nFieldsZ;
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
        List<RelDataTypeField> joinFields = semiJoin.getRowType().getFieldList();
        for (i = 0; i < nFieldsX + nFieldsY; ++i) {
            fields.add(joinFields.get(i));
        }
        joinFields = semiJoin.getRight().getRowType().getFieldList();
        for (i = 0; i < nFieldsZ; ++i) {
            fields.add(joinFields.get(i));
        }
        int nKeysFromX = 0;
        for (int leftKey : leftKeys) {
            if (leftKey >= nFieldsX) continue;
            ++nKeysFromX;
        }
        assert (nKeysFromX == 0 || nKeysFromX == leftKeys.size());
        int[] adjustments = new int[nTotalFields];
        if (nKeysFromX > 0) {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, 0, -nFieldsY);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields, adjustments));
            newLeftKeys = leftKeys;
        } else {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, -nFieldsX, -nFieldsX);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields, adjustments));
            newLeftKeys = RelOptUtil.adjustKeys(leftKeys, -nFieldsX);
        }
        RelNode leftSemiJoinOp = nKeysFromX > 0 ? join.getLeft() : join.getRight();
        SemiJoin newSemiJoin = new SemiJoin(semiJoin.getCluster(), semiJoin.getCluster().traitSetOf(Convention.NONE), leftSemiJoinOp, semiJoin.getRight(), newSemiJoinFilter, ImmutableIntList.copyOf(newLeftKeys), rightKeys);
        if (nKeysFromX > 0) {
            leftJoinRel = newSemiJoin;
            rightJoinRel = join.getRight();
        } else {
            leftJoinRel = join.getLeft();
            rightJoinRel = newSemiJoin;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), join.getCondition(), leftJoinRel, rightJoinRel, join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoinRel);
    }

    private void setJoinAdjustments(int[] adjustments, int nFieldsX, int nFieldsY, int nFieldsZ, int adjustY, int adjustZ) {
        int i;
        for (i = 0; i < nFieldsX; ++i) {
            adjustments[i] = 0;
        }
        for (i = nFieldsX; i < nFieldsX + nFieldsY; ++i) {
            adjustments[i] = adjustY;
        }
        for (i = nFieldsX + nFieldsY; i < nFieldsX + nFieldsY + nFieldsZ; ++i) {
            adjustments[i] = adjustZ;
        }
    }
}

