/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtils {
    static final boolean BRIDGE_METHODS = true;
    static final List<ParameterExpression> NO_PARAMS = ImmutableList.of();
    static final List<Expression> NO_EXPRS = ImmutableList.of();
    public static final String[] LEFT_RIGHT = new String[]{"left", "right"};

    private EnumUtils() {
    }

    public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
        return Expressions.methodDecl((int)(method.getModifiers() & 0xFFFFFBFF), method.getReturnType(), (String)method.getName(), parameters, (BlockStatement)body);
    }

    static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz = typeFactory.getJavaClass(type);
        return clazz instanceof Class ? clazz : Object[].class;
    }

    static Class javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz;
        if (type.isStruct() && type.getFieldCount() == 1) {
            type = type.getFieldList().get(0).getType();
        }
        return (clazz = typeFactory.getJavaClass(type)) instanceof Class ? (Class)clazz : Object[].class;
    }

    static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final List<? extends RelDataType> inputTypes) {
        return new AbstractList<Type>(){

            @Override
            public Type get(int index) {
                return EnumUtils.javaClass(typeFactory, (RelDataType)inputTypes.get(index));
            }

            @Override
            public int size() {
                return inputTypes.size();
            }
        };
    }

    static List<RelDataType> fieldRowTypes(RelDataType inputRowType, final List<? extends RexNode> extraInputs, final List<Integer> argList) {
        final List<RelDataTypeField> inputFields = inputRowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                int arg = (Integer)argList.get(index);
                return arg < inputFields.size() ? ((RelDataTypeField)inputFields.get(arg)).getType() : ((RexNode)extraInputs.get(arg - inputFields.size())).getType();
            }

            @Override
            public int size() {
                return argList.size();
            }
        };
    }

    static Expression joinSelector(JoinRelType joinType, PhysType physType, List<PhysType> inputPhysTypes) {
        ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int outputFieldCount = physType.getRowType().getFieldCount();
        for (Ord ord : Ord.zip(inputPhysTypes)) {
            PhysType inputPhysType = ((PhysType)ord.e).makeNullable(joinType.generatesNullsOn(ord.i));
            ParameterExpression parameter = Expressions.parameter((Type)Primitive.box((Type)inputPhysType.getJavaRowType()), (String)LEFT_RIGHT[ord.i]);
            parameters.add(parameter);
            if (expressions.size() == outputFieldCount) break;
            int fieldCount = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                Expression expression = inputPhysType.fieldReference((Expression)parameter, i, physType.getJavaFieldType(expressions.size()));
                if (joinType.generatesNullsOn(ord.i)) {
                    expression = Expressions.condition((Expression)Expressions.equal((Expression)parameter, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)expression);
                }
                expressions.add(expression);
            }
        }
        return Expressions.lambda(Function2.class, (Expression)physType.record(expressions), parameters);
    }
}

