/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.clone;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractQueryable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.util.ImmutableBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListTable
extends AbstractQueryableTable {
    private final RelProtoDataType protoRowType;
    private final Expression expression;
    private final List list;

    public ListTable(Type elementType, RelProtoDataType protoRowType, Expression expression, List list) {
        super(elementType);
        this.protoRowType = protoRowType;
        this.expression = expression;
        this.list = list;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.of(this.list.size(), (List<ImmutableBitSet>)ImmutableList.of());
    }

    @Override
    public <T> Queryable<T> asQueryable(final QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractQueryable<T>(){

            public Type getElementType() {
                return ListTable.this.elementType;
            }

            public Expression getExpression() {
                return ListTable.this.expression;
            }

            public QueryProvider getProvider() {
                return queryProvider;
            }

            public Iterator<T> iterator() {
                return ListTable.this.list.iterator();
            }

            public Enumerator<T> enumerator() {
                return Linq4j.enumerator((Collection)ListTable.this.list);
            }
        };
    }
}

