/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class NuoDbDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(NuoDbDialect.class, Dialect.DatabaseProduct.NUODB);

    public NuoDbDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, " FROM DUAL", false);
    }

    @Override
    protected void quoteDateLiteral(StringBuilder buf, String value, Date date) {
        buf.append("DATE(");
        Util.singleQuoteString(value, buf);
        buf.append(")");
    }

    @Override
    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        String identifierQuoteString = super.deduceIdentifierQuoteString(databaseMetaData);
        if (" ".equals(identifierQuoteString)) {
            identifierQuoteString = "\"";
        }
        return identifierQuoteString;
    }
}

