/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.TupleList;
import mondrian.olap.Aggregator;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.MondrianException;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.spi.Dialect;

public abstract class RolapAggregator
extends EnumeratedValues.BasicValue
implements Aggregator {
    private static int index = 0;
    public static final RolapAggregator Sum = new RolapAggregator("sum", index++, false){

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            return FunUtil.sum(evaluator, members, exp);
        }

        @Override
        public boolean supportsFastAggregates(Dialect.Datatype dataType) {
            switch (dataType) {
                case Integer: 
                case Numeric: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object aggregate(List<Object> rawData, Dialect.Datatype datatype) {
            assert (rawData.size() > 0);
            switch (datatype) {
                case Integer: {
                    int sumInt = Integer.MIN_VALUE;
                    for (Object data : rawData) {
                        if (data == null) continue;
                        if (sumInt == Integer.MIN_VALUE) {
                            sumInt = 0;
                        }
                        if (data instanceof Double) {
                            data = ((Double)data).intValue();
                        }
                        sumInt += ((Integer)data).intValue();
                    }
                    return sumInt == Integer.MIN_VALUE ? null : Integer.valueOf(sumInt);
                }
                case Numeric: {
                    double sumDouble = Double.MIN_VALUE;
                    for (Object data : rawData) {
                        if (data == null) continue;
                        if (sumDouble == Double.MIN_VALUE) {
                            sumDouble = 0.0;
                        }
                        sumDouble += ((Number)data).doubleValue();
                    }
                    return sumDouble == Double.MIN_VALUE ? null : Double.valueOf(sumDouble);
                }
            }
            throw new MondrianException("Aggregator " + this.name + " does not support datatype" + datatype.name());
        }
    };
    public static final RolapAggregator Count = new RolapAggregator("count", index++, false){

        @Override
        public Aggregator getRollup() {
            return Sum;
        }

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            return FunUtil.count(evaluator, members, false);
        }
    };
    public static final RolapAggregator Min = new RolapAggregator("min", index++, false){

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            return FunUtil.min(evaluator, members, exp);
        }

        @Override
        public boolean supportsFastAggregates(Dialect.Datatype dataType) {
            switch (dataType) {
                case Integer: 
                case Numeric: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object aggregate(List<Object> rawData, Dialect.Datatype datatype) {
            assert (rawData.size() > 0);
            switch (datatype) {
                case Integer: {
                    int minInt = Integer.MAX_VALUE;
                    for (Object data : rawData) {
                        if (data == null) continue;
                        minInt = Math.min(minInt, (Integer)data);
                    }
                    return minInt == Integer.MAX_VALUE ? null : Integer.valueOf(minInt);
                }
                case Numeric: {
                    double minDouble = Double.MAX_VALUE;
                    for (Object data : rawData) {
                        if (data == null) continue;
                        minDouble = Math.min(minDouble, ((Number)data).doubleValue());
                    }
                    return minDouble == Double.MAX_VALUE ? null : Double.valueOf(minDouble);
                }
            }
            throw new MondrianException("Aggregator " + this.name + " does not support datatype" + datatype.name());
        }
    };
    public static final RolapAggregator Max = new RolapAggregator("max", index++, false){

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            return FunUtil.max(evaluator, members, exp);
        }

        @Override
        public boolean supportsFastAggregates(Dialect.Datatype dataType) {
            switch (dataType) {
                case Integer: 
                case Numeric: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object aggregate(List<Object> rawData, Dialect.Datatype datatype) {
            assert (rawData.size() > 0);
            switch (datatype) {
                case Integer: {
                    int maxInt = Integer.MIN_VALUE;
                    for (Object data : rawData) {
                        if (data == null) continue;
                        maxInt = Math.max(maxInt, (Integer)data);
                    }
                    return maxInt == Integer.MIN_VALUE ? null : Integer.valueOf(maxInt);
                }
                case Numeric: {
                    double maxDouble = Double.MIN_VALUE;
                    for (Object data : rawData) {
                        if (data == null) continue;
                        maxDouble = Math.max(maxDouble, ((Number)data).doubleValue());
                    }
                    return maxDouble == Double.MIN_VALUE ? null : Double.valueOf(maxDouble);
                }
            }
            throw new MondrianException("Aggregator " + this.name + " does not support datatype" + datatype.name());
        }
    };
    public static final RolapAggregator Avg = new RolapAggregator("avg", index++, false){

        @Override
        public Aggregator getRollup() {
            return new RolapAggregator("avg", index, false){

                @Override
                public Object aggregate(Evaluator evaluator, TupleList members, Calc calc) {
                    return AggregateFunDef.avg(evaluator, members, calc);
                }
            };
        }

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            return AggregateFunDef.avg(evaluator, members, exp);
        }
    };
    public static final RolapAggregator DistinctCount = new RolapAggregator("distinct-count", index++, true){

        @Override
        public Aggregator getRollup() {
            return Sum;
        }

        @Override
        public RolapAggregator getNonDistinctAggregator() {
            return Count;
        }

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExpression(String operand) {
            return "count(distinct " + operand + ")";
        }

        @Override
        public boolean supportsFastAggregates(Dialect.Datatype dataType) {
            return false;
        }
    };
    public static final EnumeratedValues<RolapAggregator> enumeration = new EnumeratedValues((EnumeratedValues.Value[])new RolapAggregator[]{Sum, Count, Min, Max, Avg, DistinctCount});
    private final boolean distinct;

    public RolapAggregator(String name, int ordinal, boolean distinct) {
        super(name, ordinal, null);
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getExpression(String operand) {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.name);
        buf.append('(');
        if (this.distinct) {
            buf.append("distinct ");
        }
        buf.append(operand);
        buf.append(')');
        return buf.toString();
    }

    public RolapAggregator getNonDistinctAggregator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Aggregator getRollup() {
        return this;
    }

    @Override
    public boolean supportsFastAggregates(Dialect.Datatype dataType) {
        return false;
    }

    @Override
    public Object aggregate(List<Object> rawData, Dialect.Datatype datatype) {
        throw new UnsupportedOperationException();
    }

    public static class SumFromAvg
    extends BaseAggor {
        public SumFromAvg(String factCountExpr) {
            super("SumFromAvg", factCountExpr);
        }

        @Override
        public String getExpression(String operand) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("sum(");
            buf.append(operand);
            buf.append(" * ");
            buf.append(this.factCountExpr);
            buf.append(')');
            return buf.toString();
        }

        @Override
        public boolean alwaysRequiresFactColumn() {
            return true;
        }

        @Override
        public String getScalarExpression(String operand) {
            return new StringBuilder(64).append('(').append(operand).append(") * (").append(this.factCountExpr).append(')').toString();
        }
    }

    public static class AvgFromAvg
    extends BaseAggor {
        public AvgFromAvg(String factCountExpr) {
            super("AvgFromAvg", factCountExpr);
        }

        @Override
        public String getExpression(String operand) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("sum(");
            buf.append(operand);
            buf.append(" * ");
            buf.append(this.factCountExpr);
            buf.append(") / sum(");
            buf.append(this.factCountExpr);
            buf.append(')');
            return buf.toString();
        }

        @Override
        public boolean alwaysRequiresFactColumn() {
            return false;
        }

        @Override
        public String getScalarExpression(String operand) {
            throw new UnsupportedOperationException("This method should not be invoked if alwaysRequiresFactColumn() is false");
        }
    }

    public static class AvgFromSum
    extends BaseAggor {
        public AvgFromSum(String factCountExpr) {
            super("AvgFromSum", factCountExpr);
        }

        @Override
        public String getExpression(String operand) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("sum(");
            buf.append(operand);
            buf.append(") / sum(");
            buf.append(this.factCountExpr);
            buf.append(')');
            return buf.toString();
        }

        @Override
        public boolean alwaysRequiresFactColumn() {
            return true;
        }

        @Override
        public String getScalarExpression(String operand) {
            return new StringBuilder(64).append('(').append(operand).append(") / (").append(this.factCountExpr).append(')').toString();
        }
    }

    public static abstract class BaseAggor
    extends RolapAggregator {
        protected final String factCountExpr;

        protected BaseAggor(String name, String factCountExpr) {
            super(name, index++, false);
            this.factCountExpr = factCountExpr;
        }

        @Override
        public Object aggregate(Evaluator evaluator, TupleList members, Calc exp) {
            throw new UnsupportedOperationException();
        }

        public abstract boolean alwaysRequiresFactColumn();

        public abstract String getScalarExpression(String var1);
    }
}

