/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.olap4j.MondrianOlap4jSchema;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

class MondrianOlap4jDimension
extends MondrianOlap4jMetadataElement
implements org.olap4j.metadata.Dimension,
Named {
    private final MondrianOlap4jSchema olap4jSchema;
    private final Dimension dimension;

    MondrianOlap4jDimension(MondrianOlap4jSchema olap4jSchema, Dimension dimension) {
        this.olap4jSchema = olap4jSchema;
        this.dimension = dimension;
    }

    public boolean equals(Object obj) {
        return obj instanceof MondrianOlap4jDimension && this.dimension.equals(((MondrianOlap4jDimension)obj).dimension);
    }

    public int hashCode() {
        return this.dimension.hashCode();
    }

    public NamedList<org.olap4j.metadata.Hierarchy> getHierarchies() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        SchemaReader schemaReader = olap4jConnection.getMondrianConnection2().getSchemaReader().withLocus();
        for (Hierarchy hierarchy : schemaReader.getDimensionHierarchies(this.dimension)) {
            list.add((Object)olap4jConnection.toOlap4j(hierarchy));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public org.olap4j.metadata.Hierarchy getDefaultHierarchy() {
        return (org.olap4j.metadata.Hierarchy)this.getHierarchies().get(0);
    }

    public Dimension.Type getDimensionType() throws OlapException {
        DimensionType dimensionType = this.dimension.getDimensionType();
        switch (dimensionType) {
            case StandardDimension: {
                return Dimension.Type.OTHER;
            }
            case MeasuresDimension: {
                return Dimension.Type.MEASURE;
            }
            case TimeDimension: {
                return Dimension.Type.TIME;
            }
        }
        throw Util.unexpected(dimensionType);
    }

    public String getName() {
        return this.dimension.getName();
    }

    public String getUniqueName() {
        return this.dimension.getUniqueName();
    }

    public String getCaption() {
        return this.dimension.getLocalized(OlapElement.LocalizedProperty.CAPTION, this.olap4jSchema.getLocale());
    }

    public String getDescription() {
        return this.dimension.getLocalized(OlapElement.LocalizedProperty.DESCRIPTION, this.olap4jSchema.getLocale());
    }

    public boolean isVisible() {
        return this.dimension.isVisible();
    }

    @Override
    protected OlapElement getOlapElement() {
        return this.dimension;
    }
}

