/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOCogroup
extends LogicalRelationalOperator {
    private boolean[] mIsInner;
    private MultiMap<Integer, LogicalExpressionPlan> mExpressionPlans;
    private GROUPTYPE mGroupType;
    private LogicalSchema.LogicalFieldSchema groupKeyUidOnlySchema;
    private Map<Integer, Long> generatedInputUids = new HashMap<Integer, Long>();
    static final String GROUP_COL_NAME = "group";
    public static final Integer OPTION_GROUPTYPE = 1;

    public LOCogroup(LogicalPlan plan) {
        super("LOCogroup", plan);
    }

    public LOCogroup(OperatorPlan plan, MultiMap<Integer, LogicalExpressionPlan> expressionPlans, boolean[] isInner) {
        this(plan, expressionPlans, GROUPTYPE.REGULAR, isInner);
    }

    public LOCogroup(OperatorPlan plan, MultiMap<Integer, LogicalExpressionPlan> expressionPlans, GROUPTYPE groupType, boolean[] isInner) {
        super("LOCogroup", plan);
        this.mExpressionPlans = expressionPlans;
        if (isInner != null) {
            this.mIsInner = Arrays.copyOf(isInner, isInner.length);
        }
        this.mGroupType = groupType;
    }

    private LogicalSchema.LogicalFieldSchema getPlanSchema(LogicalExpressionPlan exprPlan) throws FrontendException {
        LogicalExpression sourceExp = (LogicalExpression)exprPlan.getSources().get(0);
        LogicalSchema.LogicalFieldSchema planSchema = null;
        if (sourceExp.getFieldSchema() != null) {
            planSchema = sourceExp.getFieldSchema().deepCopy();
        }
        return planSchema;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        List<Operator> inputs = null;
        inputs = this.plan.getPredecessors(this);
        if (inputs == null) {
            throw new FrontendException(this, "Cannot get predecessor for " + this, 2233);
        }
        ArrayList<LogicalSchema.LogicalFieldSchema> fieldSchemaList = new ArrayList<LogicalSchema.LogicalFieldSchema>();
        boolean hasMultipleKeys = false;
        for (Integer key : this.mExpressionPlans.keySet()) {
            if (this.mExpressionPlans.get(key).size() <= 1) continue;
            hasMultipleKeys = true;
            break;
        }
        LogicalSchema.LogicalFieldSchema groupKeySchema = null;
        if (hasMultipleKeys) {
            LogicalSchema keySchema = new LogicalSchema();
            Iterator<Serializable> i$ = this.mExpressionPlans.keySet().iterator();
            if (i$.hasNext()) {
                Integer key = i$.next();
                List<LogicalExpressionPlan> plans = this.mExpressionPlans.get(key);
                for (LogicalExpressionPlan plan : plans) {
                    LogicalSchema.LogicalFieldSchema fieldSchema = this.getPlanSchema(plan);
                    if (fieldSchema == null) {
                        this.schema = null;
                        return this.schema;
                    }
                    fieldSchema = new LogicalSchema.LogicalFieldSchema(fieldSchema);
                    keySchema.addField(fieldSchema);
                }
            }
            groupKeySchema = new LogicalSchema.LogicalFieldSchema(GROUP_COL_NAME, keySchema, 110);
        } else {
            Integer key;
            List<LogicalExpressionPlan> plans;
            Iterator i$;
            Iterator<Integer> i$2 = this.mExpressionPlans.keySet().iterator();
            if (i$2.hasNext() && (i$ = (plans = this.mExpressionPlans.get(key = i$2.next())).iterator()).hasNext()) {
                LogicalExpressionPlan plan = (LogicalExpressionPlan)i$.next();
                groupKeySchema = this.getPlanSchema(plan);
                if (groupKeySchema == null) {
                    groupKeySchema = new LogicalSchema.LogicalFieldSchema(GROUP_COL_NAME, null, 110);
                } else {
                    groupKeySchema = new LogicalSchema.LogicalFieldSchema(groupKeySchema);
                    groupKeySchema.alias = GROUP_COL_NAME;
                }
            }
        }
        if (this.mExpressionPlans.size() > 1) {
            groupKeySchema.resetUid();
        }
        if (groupKeySchema == null) {
            throw new FrontendException(this, "Cannot get group key schema for " + this, 2234);
        }
        this.groupKeyUidOnlySchema = groupKeySchema.mergeUid(this.groupKeyUidOnlySchema);
        fieldSchemaList.add(groupKeySchema);
        int counter = 0;
        for (Operator op : inputs) {
            long bagUid;
            LogicalSchema inputSchema = ((LogicalRelationalOperator)op).getSchema();
            if (this.generatedInputUids.get(counter) != null) {
                bagUid = this.generatedInputUids.get(counter);
            } else {
                bagUid = LogicalExpression.getNextUid();
                this.generatedInputUids.put(counter, bagUid);
            }
            LogicalSchema.LogicalFieldSchema newTupleFieldSchema = new LogicalSchema.LogicalFieldSchema(null, inputSchema, 110, LogicalExpression.getNextUid());
            LogicalSchema bagSchema = new LogicalSchema();
            bagSchema.addField(newTupleFieldSchema);
            LogicalSchema.LogicalFieldSchema newBagFieldSchema = new LogicalSchema.LogicalFieldSchema(((LogicalRelationalOperator)op).getAlias(), bagSchema, 120, bagUid);
            fieldSchemaList.add(newBagFieldSchema);
            ++counter;
        }
        this.schema = new LogicalSchema();
        for (LogicalSchema.LogicalFieldSchema fieldSchema : fieldSchemaList) {
            this.schema.addField(fieldSchema);
        }
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOCogroup) {
            LOCogroup oc = (LOCogroup)other;
            if (this.mGroupType == oc.mGroupType && this.mIsInner.length == oc.mIsInner.length && this.mExpressionPlans.size() == oc.mExpressionPlans.size()) {
                for (int i = 0; i < this.mIsInner.length; ++i) {
                    if (this.mIsInner[i] == oc.mIsInner[i]) continue;
                    return false;
                }
                for (Integer key : this.mExpressionPlans.keySet()) {
                    if (!oc.mExpressionPlans.containsKey(key)) {
                        return false;
                    }
                    List<LogicalExpressionPlan> exp1 = this.mExpressionPlans.get(key);
                    List<LogicalExpressionPlan> exp2 = oc.mExpressionPlans.get(key);
                    if (!(exp1 instanceof ArrayList) && !(exp2 instanceof ArrayList)) {
                        throw new FrontendException("Expected an ArrayList of Expression Plans", 2235);
                    }
                    ArrayList expList1 = (ArrayList)exp1;
                    ArrayList expList2 = (ArrayList)exp2;
                    for (int i = 0; i < expList1.size(); ++i) {
                        if (((LogicalExpressionPlan)expList1.get(i)).isEqual((OperatorPlan)expList2.get(i))) continue;
                        return false;
                    }
                }
                return this.checkEquality((LogicalRelationalOperator)other);
            }
        }
        return false;
    }

    public GROUPTYPE getGroupType() {
        return this.mGroupType;
    }

    public void resetGroupType() {
        this.mGroupType = GROUPTYPE.REGULAR;
    }

    public Map<Integer, Long> getGeneratedInputUids() {
        return Collections.unmodifiableMap(this.generatedInputUids);
    }

    public MultiMap<Integer, LogicalExpressionPlan> getExpressionPlans() {
        return this.mExpressionPlans;
    }

    public void setExpressionPlans(MultiMap<Integer, LogicalExpressionPlan> plans) {
        this.mExpressionPlans = plans;
    }

    public void setGroupType(GROUPTYPE gt) {
        this.mGroupType = gt;
    }

    public void setInnerFlags(boolean[] flags) {
        if (flags != null) {
            this.mIsInner = Arrays.copyOf(flags, flags.length);
        }
    }

    public boolean[] getInner() {
        return this.mIsInner;
    }

    @Override
    public void resetUid() {
        this.groupKeyUidOnlySchema = null;
        this.generatedInputUids = new HashMap<Integer, Long>();
    }

    public List<Operator> getInputs(LogicalPlan plan) {
        return plan.getPredecessors(this);
    }

    public static enum GROUPTYPE {
        REGULAR,
        COLLECTED,
        MERGE;

    }
}

