/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;

public abstract class PigNullableWritable
implements WritableComparable {
    public static final byte mqFlag = -128;
    public static final byte idxSpace = 127;
    private boolean mNull;
    protected WritableComparable mValue;
    private byte mIndex;

    public int compareTo(Object o) {
        PigNullableWritable w = (PigNullableWritable)o;
        if ((this.mIndex & 0xFFFFFF80) != 0) {
            if ((this.mIndex & 0x7F) < (w.mIndex & 0x7F)) {
                return -1;
            }
            if ((this.mIndex & 0x7F) > (w.mIndex & 0x7F)) {
                return 1;
            }
        }
        if (!this.mNull && !w.mNull) {
            int result = this.mValue.compareTo((Object)w.mValue);
            if (result == 0 && this.mValue instanceof Tuple && w.mValue instanceof Tuple) {
                try {
                    for (int i = 0; i < ((Tuple)this.mValue).size(); ++i) {
                        if (((Tuple)this.mValue).get(i) != null) continue;
                        return this.mIndex - w.mIndex;
                    }
                }
                catch (ExecException e) {
                    throw new RuntimeException("Unable to access tuple field", e);
                }
            }
            return result;
        }
        if (this.mNull && w.mNull) {
            if ((this.mIndex & 0x7F) < (w.mIndex & 0x7F)) {
                return -1;
            }
            if ((this.mIndex & 0x7F) > (w.mIndex & 0x7F)) {
                return 1;
            }
            return 0;
        }
        if (this.mNull) {
            return -1;
        }
        return 1;
    }

    public void readFields(DataInput in) throws IOException {
        this.mNull = in.readBoolean();
        if (!this.mNull) {
            this.mValue.readFields(in);
        }
        this.mIndex = in.readByte();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.mNull);
        if (!this.mNull) {
            this.mValue.write(out);
        }
        out.writeByte(this.mIndex);
    }

    public boolean isNull() {
        return this.mNull;
    }

    public void setNull(boolean isNull) {
        this.mNull = isNull;
    }

    public byte getIndex() {
        return this.mIndex;
    }

    public void setIndex(byte index) {
        this.mIndex = index;
    }

    public abstract Object getValueAsPigType();

    public int hashCode() {
        if (this.mNull) {
            return 0;
        }
        return this.mValue.hashCode();
    }

    public boolean equals(Object arg0) {
        return this.compareTo(arg0) == 0;
    }

    public String toString() {
        return "Null: " + this.mNull + " index: " + this.mIndex + " " + this.mValue.toString();
    }
}

