/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data.utils;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MethodHelper {
    private MethodHelper() {
    }

    public static boolean isNotImplementedAnnotationPresent(Method m, Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return false;
        }
        for (Method clazzMethod : clazz.getDeclaredMethods()) {
            if (!MethodHelper.methodSignatureEqual(m, clazzMethod)) continue;
            return clazzMethod.getAnnotation(NotImplemented.class) != null;
        }
        return MethodHelper.isNotImplementedAnnotationPresent(m, clazz.getSuperclass());
    }

    public static RuntimeException methodNotImplemented() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        StackTraceElement pre = ste[ste.length - 2];
        return new UnsupportedOperationException(pre.getMethodName() + " not implemented in " + pre.getClassName());
    }

    public static boolean methodSignatureEqual(Method m1, Method m2) {
        Class<?>[] params2;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        Class<?>[] params1 = m1.getParameterTypes();
        if (params1.length == (params2 = m2.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].equals(params2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NotImplemented {
    }
}

