/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.legacycharts;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.AttributeExpressionEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.extensions.legacycharts.ChartEditingResult;
import org.pentaho.reporting.designer.extensions.legacycharts.LegacyChartEditorDialog;
import org.pentaho.reporting.designer.extensions.legacycharts.Messages;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.extensions.legacy.charts.LegacyChartType;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class LegacyChartsUtil {
    private LegacyChartsUtil() {
    }

    public static boolean isLegacyChartElement(Element element) {
        if (element.getElementType() instanceof LegacyChartType) {
            return true;
        }
        Expression valueExpression = element.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        return valueExpression instanceof AbstractChartExpression;
    }

    public static void performEdit(Element chartElement, ReportDesignerContext context) {
        ReportDocumentContext activeContext = context.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        LegacyChartEditorDialog dialog = window instanceof JDialog ? new LegacyChartEditorDialog((JDialog)window) : (window instanceof JFrame ? new LegacyChartEditorDialog((JFrame)window) : new LegacyChartEditorDialog());
        try {
            ChartEditingResult editResult = dialog.performEdit(chartElement, context);
            if (editResult != null) {
                ArrayList<Object> undoEntries = new ArrayList<Object>();
                undoEntries.add(new AttributeExpressionEditUndoEntry(chartElement.getObjectID(), "http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", editResult.getOriginalChartExpression(), editResult.getChartExpression()));
                undoEntries.add(new AttributeEditUndoEntry(chartElement.getObjectID(), "http://reporting.pentaho.org/namespaces/engine/classic/legacy/charting/1.0", "primary-dataset-expression", (Object)editResult.getOriginalPrimaryDataSource(), (Object)editResult.getPrimaryDataSource()));
                undoEntries.add(new AttributeEditUndoEntry(chartElement.getObjectID(), "http://reporting.pentaho.org/namespaces/engine/classic/legacy/charting/1.0", "secondary-dataset-expression", (Object)editResult.getOriginalSecondaryDataSource(), (Object)editResult.getSecondaryDataSource()));
                CompoundUndoEntry ue = new CompoundUndoEntry(undoEntries.toArray(new UndoEntry[undoEntries.size()]));
                activeContext.getUndo().addChange(Messages.getInstance().getString("EditLegacyChartAction.Undo"), (UndoEntry)ue);
                ue.redo(context.getActiveContext());
            }
        }
        catch (CloneNotSupportedException e1) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
        }
    }
}

