/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.lifecycle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.InvalidSyntaxException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.osgi.OSGIPlugin;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.OSGIServiceLifecycleListener;
import org.pentaho.di.osgi.service.tracker.PdiPluginSupplementalClassMappingsTracker;

public class PluginRegistryOSGIServiceLifecycleListener
implements OSGIServiceLifecycleListener<PluginInterface> {
    private final PluginRegistry registry;
    private Log logger = LogFactory.getLog((String)this.getClass().getName());

    public PluginRegistryOSGIServiceLifecycleListener(PluginRegistry registry) {
        this.registry = registry;
    }

    protected void setLogger(Log logger) {
        this.logger = logger;
    }

    @Override
    public void pluginAdded(PluginInterface serviceObject) {
        try {
            OSGIPlugin osgiPlugin = (OSGIPlugin)serviceObject;
            Class<? extends PluginTypeInterface> pluginTypeFromPlugin = osgiPlugin.getPluginType();
            try {
                this.registry.registerPlugin(pluginTypeFromPlugin, serviceObject);
                this.openServiceTracker(pluginTypeFromPlugin, osgiPlugin);
            }
            catch (KettlePluginException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error notifying listener of plugin addition", (Throwable)e);
        }
    }

    private void openServiceTracker(Class<? extends PluginTypeInterface> pluginTypeFromPlugin, OSGIPlugin osgiPlugin) {
        try {
            new PdiPluginSupplementalClassMappingsTracker(OSGIPluginTracker.getInstance().getBundleContext(), pluginTypeFromPlugin, osgiPlugin).open();
        }
        catch (InvalidSyntaxException e) {
            this.logger.error((Object)"Error constructing filter for Class Mapping Tracker", (Throwable)e);
        }
    }

    @Override
    public void pluginRemoved(PluginInterface serviceObject) {
        try {
            OSGIPlugin osgiPlugin = (OSGIPlugin)serviceObject;
            Class<? extends PluginTypeInterface> pluginTypeFromPlugin = osgiPlugin.getPluginType();
            this.registry.removePlugin(pluginTypeFromPlugin, serviceObject);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error notifying listener of plugin removal", (Throwable)e);
        }
    }

    @Override
    public void pluginChanged(PluginInterface serviceObject) {
    }
}

