/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.api;

import java.util.List;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.ITwoWayPasswordEncoder;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;

public interface IMetaStore {
    public List<String> getNamespaces() throws MetaStoreException;

    public void createNamespace(String var1) throws MetaStoreException, MetaStoreNamespaceExistsException;

    public void deleteNamespace(String var1) throws MetaStoreException, MetaStoreDependenciesExistsException;

    public boolean namespaceExists(String var1) throws MetaStoreException;

    public List<IMetaStoreElementType> getElementTypes(String var1) throws MetaStoreException;

    public List<String> getElementTypeIds(String var1) throws MetaStoreException;

    public IMetaStoreElementType getElementType(String var1, String var2) throws MetaStoreException;

    public IMetaStoreElementType getElementTypeByName(String var1, String var2) throws MetaStoreException;

    public void createElementType(String var1, IMetaStoreElementType var2) throws MetaStoreException, MetaStoreElementTypeExistsException;

    public void updateElementType(String var1, IMetaStoreElementType var2) throws MetaStoreException;

    public void deleteElementType(String var1, IMetaStoreElementType var2) throws MetaStoreException, MetaStoreDependenciesExistsException;

    public List<IMetaStoreElement> getElements(String var1, IMetaStoreElementType var2) throws MetaStoreException;

    public List<String> getElementIds(String var1, IMetaStoreElementType var2) throws MetaStoreException;

    public IMetaStoreElement getElement(String var1, IMetaStoreElementType var2, String var3) throws MetaStoreException;

    public IMetaStoreElement getElementByName(String var1, IMetaStoreElementType var2, String var3) throws MetaStoreException;

    public void createElement(String var1, IMetaStoreElementType var2, IMetaStoreElement var3) throws MetaStoreException, MetaStoreElementExistException;

    public void deleteElement(String var1, IMetaStoreElementType var2, String var3) throws MetaStoreException;

    public void updateElement(String var1, IMetaStoreElementType var2, String var3, IMetaStoreElement var4) throws MetaStoreException;

    public IMetaStoreElementType newElementType(String var1) throws MetaStoreException;

    public IMetaStoreElement newElement() throws MetaStoreException;

    public IMetaStoreElement newElement(IMetaStoreElementType var1, String var2, Object var3) throws MetaStoreException;

    public IMetaStoreAttribute newAttribute(String var1, Object var2) throws MetaStoreException;

    public IMetaStoreElementOwner newElementOwner(String var1, MetaStoreElementOwnerType var2) throws MetaStoreException;

    public String getName() throws MetaStoreException;

    public String getDescription() throws MetaStoreException;

    public void setTwoWayPasswordEncoder(ITwoWayPasswordEncoder var1);

    public ITwoWayPasswordEncoder getTwoWayPasswordEncoder();
}

