/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.table;

import java.awt.Paint;
import java.awt.SystemColor;
import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.FormattingTableCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.PaintCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.date.DateCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.date.TimeCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.PropertyCellEditorWithEllipsis;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.PropertyEditorCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.PropertyEditorCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;
import org.pentaho.reporting.libraries.designtime.swing.table.ArrayCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.table.ArrayCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTableModel;

public class PropertyTable
extends JTable {
    public static final String DATETIME_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss.SSSS";
    public static final String TIME_FORMAT_DEFAULT = "HH:mm:ss.SSSS";
    public static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    private static Log logger = LogFactory.getLog(PropertyTable.class);
    private PropertyEditorCellRenderer propertyEditorCellRenderer;
    private PropertyCellEditorWithEllipsis propertyEditorCellEditor;
    private PropertyEditorCellEditor taggedPropertyEditorCellEditor;
    private ArrayCellRenderer arrayCellRenderer;
    private ArrayCellEditor arrayCellEditor;

    public PropertyTable() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setGridColor(SystemColor.controlShadow);
        this.taggedPropertyEditorCellEditor = new PropertyEditorCellEditor();
        this.propertyEditorCellEditor = new PropertyCellEditorWithEllipsis();
        this.propertyEditorCellRenderer = new PropertyEditorCellRenderer();
        this.arrayCellRenderer = new ArrayCellRenderer();
        this.arrayCellEditor = new ArrayCellEditor();
        this.setDefaultEditor(Object.class, null);
        this.setDefaultEditor(Number.class, new GenericCellEditor(BigDecimal.class));
        this.setDefaultEditor(Integer.class, new GenericCellEditor(Integer.class));
        this.setDefaultEditor(Float.class, new GenericCellEditor(Float.class));
        this.setDefaultEditor(Double.class, new GenericCellEditor(Double.class));
        this.setDefaultEditor(Short.class, new GenericCellEditor(Short.class));
        this.setDefaultEditor(Byte.class, new GenericCellEditor(Byte.class));
        this.setDefaultEditor(Long.class, new GenericCellEditor(Long.class));
        this.setDefaultEditor(BigInteger.class, new GenericCellEditor(BigInteger.class));
        this.setDefaultEditor(BigDecimal.class, new GenericCellEditor(BigDecimal.class));
        this.setDefaultEditor(String.class, new GenericCellEditor(String.class));
        this.setDefaultEditor(java.util.Date.class, new DateCellEditor(java.util.Date.class));
        this.setDefaultEditor(Date.class, new DateCellEditor(java.util.Date.class));
        this.setDefaultEditor(Time.class, new TimeCellEditor(Time.class));
        this.setDefaultEditor(Timestamp.class, new DateCellEditor(Timestamp.class));
        this.setDefaultRenderer(Paint.class, new PaintCellRenderer());
        this.setDefaultRenderer(Object.class, new GenericCellRenderer());
        this.setDefaultRenderer(String.class, new GenericCellRenderer());
        SimpleDateFormat isoDateFormat = new SimpleDateFormat(DATETIME_FORMAT_DEFAULT, Locale.ENGLISH);
        this.setDefaultRenderer(java.util.Date.class, new FormattingTableCellRenderer(isoDateFormat));
        this.setDefaultRenderer(Date.class, new FormattingTableCellRenderer(new SimpleDateFormat(DATE_FORMAT_DEFAULT, Locale.ENGLISH)));
        this.setDefaultRenderer(Time.class, new FormattingTableCellRenderer(new SimpleDateFormat(TIME_FORMAT_DEFAULT, Locale.ENGLISH)));
        this.setDefaultRenderer(Timestamp.class, new FormattingTableCellRenderer(isoDateFormat));
    }

    public PropertyTable(TableModel dm) {
        this();
        this.setModel(dm);
    }

    private static SimpleDateFormat createSafely(String pattern, String defaultPattern, Locale locale) {
        try {
            if (!StringUtils.isEmpty((String)pattern)) {
                return new SimpleDateFormat(pattern, locale);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid format string found in locale settings", (Throwable)e);
        }
        return new SimpleDateFormat(defaultPattern, locale);
    }

    public void applyLocaleSettings(LocaleSettings localeSettings) {
        SimpleDateFormat isoDateFormat = PropertyTable.createSafely(localeSettings.getDatetimeFormatPattern(), DATETIME_FORMAT_DEFAULT, localeSettings.getLocale());
        TimeZone timeZone = localeSettings.getTimeZone();
        isoDateFormat.setTimeZone(timeZone);
        this.setDefaultRenderer(java.util.Date.class, new FormattingTableCellRenderer(isoDateFormat));
        this.setDefaultRenderer(Timestamp.class, new FormattingTableCellRenderer(isoDateFormat));
        DateCellEditor dateCellEditor = new DateCellEditor(java.util.Date.class);
        dateCellEditor.setDateFormat(isoDateFormat);
        this.setDefaultEditor(java.util.Date.class, dateCellEditor);
        DateCellEditor timestampEditor = new DateCellEditor(Timestamp.class);
        timestampEditor.setDateFormat(isoDateFormat);
        this.setDefaultEditor(Timestamp.class, timestampEditor);
        SimpleDateFormat dateFormat = PropertyTable.createSafely(localeSettings.getDateFormatPattern(), DATE_FORMAT_DEFAULT, localeSettings.getLocale());
        dateFormat.setTimeZone(timeZone);
        this.setDefaultRenderer(Date.class, new FormattingTableCellRenderer(dateFormat));
        DateCellEditor sqlDateCellEditor = new DateCellEditor(Date.class);
        sqlDateCellEditor.setDateFormat(dateFormat);
        this.setDefaultEditor(Date.class, sqlDateCellEditor);
        SimpleDateFormat timeFormat = PropertyTable.createSafely(localeSettings.getTimeFormatPattern(), TIME_FORMAT_DEFAULT, localeSettings.getLocale());
        timeFormat.setTimeZone(timeZone);
        this.setDefaultRenderer(Time.class, new FormattingTableCellRenderer(timeFormat));
        TimeCellEditor timeCellEditor = new TimeCellEditor(Time.class);
        timeCellEditor.setDateFormat(timeFormat);
        this.setDefaultEditor(Time.class, timeCellEditor);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int columnIndex = this.convertColumnIndexToModel(column);
        if (this.getModel().isCellEditable(row, columnIndex)) {
            return this.getCellEditor(row, columnIndex) != null;
        }
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int viewColumn) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof PropertyTableModel) {
            int column;
            PropertyTableModel model = (PropertyTableModel)this.getModel();
            Class columnClass = model.getClassForCell(row, column = this.convertColumnIndexToModel(viewColumn));
            if (columnClass.isArray()) {
                return this.arrayCellRenderer;
            }
            PropertyEditor propertyEditor = model.getEditorForCell(row, column);
            if (propertyEditor != null) {
                this.propertyEditorCellRenderer.setPropertyEditor(propertyEditor);
                return this.propertyEditorCellRenderer;
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            if (renderer != null) {
                return renderer;
            }
            TableCellRenderer defaultRenderer = this.getDefaultRenderer(columnClass);
            if (defaultRenderer != null) {
                return defaultRenderer;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("No renderer for column class " + columnClass));
            }
            return this.getDefaultRenderer(Object.class);
        }
        return super.getCellRenderer(row, viewColumn);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int viewColumn) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof PropertyTableModel) {
            TableColumn tableColumn;
            TableCellEditor renderer;
            PropertyTableModel model = (PropertyTableModel)this.getModel();
            int column = this.convertColumnIndexToModel(viewColumn);
            PropertyEditor propertyEditor = model.getEditorForCell(row, column);
            Class columnClass = model.getClassForCell(row, column);
            if (propertyEditor != null) {
                String[] tags = propertyEditor.getTags();
                if (columnClass.isArray()) {
                    this.arrayCellEditor.setPropertyEditorType(propertyEditor.getClass());
                } else {
                    if (tags == null || tags.length == 0) {
                        this.propertyEditorCellEditor.setPropertyEditor(propertyEditor);
                        return this.propertyEditorCellEditor;
                    }
                    this.taggedPropertyEditorCellEditor.setPropertyEditor(propertyEditor);
                    return this.taggedPropertyEditorCellEditor;
                }
            }
            if ((renderer = (tableColumn = this.getColumnModel().getColumn(column)).getCellEditor()) != null) {
                return renderer;
            }
            if (columnClass.isArray()) {
                return this.arrayCellEditor;
            }
            TableCellEditor editor = this.getDefaultEditor(columnClass);
            if (editor != null && logger.isTraceEnabled()) {
                logger.trace((Object)("Using preconfigured default editor for column class " + columnClass + ": " + editor));
            }
            return editor;
        }
        return super.getCellEditor(row, viewColumn);
    }

    public void stopEditing() {
        TableCellEditor cellEditor = this.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }
}

