/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastKeyStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastBytesHashMultiSet
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashMultiSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastBytesHashMultiSet.class);

    @Override
    public VectorMapJoinHashMultiSetResult createHashMultiSetResult() {
        return new VectorMapJoinFastHashMultiSet.HashMultiSetResult();
    }

    @Override
    public void assignSlot(int slot, byte[] keyBytes, int keyStart, int keyLength, long hashCode, boolean isNewKey, BytesWritable currentValue) {
        int tripleIndex = 3 * slot;
        if (isNewKey) {
            this.slotTriples[tripleIndex] = this.keyStore.add(keyBytes, keyStart, keyLength);
            this.slotTriples[tripleIndex + 1] = hashCode;
            this.slotTriples[tripleIndex + 2] = 1L;
        } else {
            int n = tripleIndex + 2;
            this.slotTriples[n] = this.slotTriples[n] + 1L;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMultiSetResult hashMultiSetResult) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastHashMultiSet.HashMultiSetResult optimizedHashMultiSetResult = (VectorMapJoinFastHashMultiSet.HashMultiSetResult)hashMultiSetResult;
        optimizedHashMultiSetResult.forget();
        long hashCode = HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
        long count = this.findReadSlot(keyBytes, keyStart, keyLength, hashCode, hashMultiSetResult.getReadPos());
        if (count == -1L) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            optimizedHashMultiSetResult.set(count);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMultiSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastBytesHashMultiSet(int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(initialCapacity, loadFactor, writeBuffersSize);
        this.keyStore = new VectorMapJoinFastKeyStore(writeBuffersSize);
    }
}

