/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.exec.tez.HostAffinitySplitLocationProvider;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.slf4j.Logger;

public class Utils {
    public static SplitLocationProvider getSplitLocationProvider(Configuration conf, Logger LOG) throws IOException {
        Object splitLocationProvider;
        boolean useCustomLocations = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS);
        LOG.info("SplitGenerator using llap affinitized locations: " + useCustomLocations);
        if (useCustomLocations) {
            LlapRegistryService serviceRegistry = LlapRegistryService.getClient(conf);
            List<ServiceInstance> serviceInstances = serviceRegistry.getInstances().getAllInstancesOrdered();
            String[] locations = new String[serviceInstances.size()];
            int i = 0;
            for (ServiceInstance serviceInstance : serviceInstances) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + serviceInstance.getWorkerIdentity() + " with hostname=" + serviceInstance.getHost() + " to list for split locations");
                }
                locations[i++] = serviceInstance.getHost();
            }
            splitLocationProvider = new HostAffinitySplitLocationProvider(locations);
        } else {
            splitLocationProvider = new SplitLocationProvider(){

                public String[] getLocations(InputSplit split) throws IOException {
                    if (split == null) {
                        return null;
                    }
                    String[] locations = split.getLocations();
                    if (locations != null && locations.length == 1 && "localhost".equals(locations[0])) {
                        return ArrayUtils.EMPTY_STRING_ARRAY;
                    }
                    return locations;
                }
            };
        }
        return splitLocationProvider;
    }
}

