/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateClusterRequestMarshaller
implements Marshaller<Request<CreateClusterRequest>, CreateClusterRequest> {
    @Override
    public Request<CreateClusterRequest> marshall(CreateClusterRequest createClusterRequest) {
        if (createClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateClusterRequest> request = new DefaultRequest<CreateClusterRequest>(createClusterRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateCluster");
        request.addParameter("Version", "2012-12-01");
        if (createClusterRequest.getDBName() != null) {
            request.addParameter("DBName", StringUtils.fromString(createClusterRequest.getDBName()));
        }
        if (createClusterRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(createClusterRequest.getClusterIdentifier()));
        }
        if (createClusterRequest.getClusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString(createClusterRequest.getClusterType()));
        }
        if (createClusterRequest.getNodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString(createClusterRequest.getNodeType()));
        }
        if (createClusterRequest.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString(createClusterRequest.getMasterUsername()));
        }
        if (createClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString(createClusterRequest.getMasterUserPassword()));
        }
        List<String> clusterSecurityGroupsList = createClusterRequest.getClusterSecurityGroups();
        int clusterSecurityGroupsListIndex = 1;
        for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
            if (clusterSecurityGroupsListValue != null) {
                request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString(clusterSecurityGroupsListValue));
            }
            ++clusterSecurityGroupsListIndex;
        }
        List<String> vpcSecurityGroupIdsList = createClusterRequest.getVpcSecurityGroupIds();
        int vpcSecurityGroupIdsListIndex = 1;
        for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
            if (vpcSecurityGroupIdsListValue != null) {
                request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
            }
            ++vpcSecurityGroupIdsListIndex;
        }
        if (createClusterRequest.getClusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString(createClusterRequest.getClusterSubnetGroupName()));
        }
        if (createClusterRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(createClusterRequest.getAvailabilityZone()));
        }
        if (createClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString(createClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (createClusterRequest.getClusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString(createClusterRequest.getClusterParameterGroupName()));
        }
        if (createClusterRequest.getAutomatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger(createClusterRequest.getAutomatedSnapshotRetentionPeriod()));
        }
        if (createClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(createClusterRequest.getPort()));
        }
        if (createClusterRequest.getClusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString(createClusterRequest.getClusterVersion()));
        }
        if (createClusterRequest.isAllowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean(createClusterRequest.isAllowVersionUpgrade()));
        }
        if (createClusterRequest.getNumberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger(createClusterRequest.getNumberOfNodes()));
        }
        if (createClusterRequest.isPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean(createClusterRequest.isPubliclyAccessible()));
        }
        if (createClusterRequest.isEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean(createClusterRequest.isEncrypted()));
        }
        if (createClusterRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString(createClusterRequest.getHsmClientCertificateIdentifier()));
        }
        if (createClusterRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString(createClusterRequest.getHsmConfigurationIdentifier()));
        }
        if (createClusterRequest.getElasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString(createClusterRequest.getElasticIp()));
        }
        return request;
    }
}

