/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadArchiveRequestMarshaller
implements Marshaller<Request<UploadArchiveRequest>, UploadArchiveRequest> {
    @Override
    public Request<UploadArchiveRequest> marshall(UploadArchiveRequest uploadArchiveRequest) {
        if (uploadArchiveRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadArchiveRequest> request = new DefaultRequest<UploadArchiveRequest>(uploadArchiveRequest, "AmazonGlacier");
        String target = "Glacier.UploadArchive";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadArchiveRequest.getContentLength() != null) {
            request.addHeader("x-amz-content-length", StringUtils.fromLong(uploadArchiveRequest.getContentLength()));
        }
        if (uploadArchiveRequest.getArchiveDescription() != null) {
            request.addHeader("x-amz-archive-description", StringUtils.fromString(uploadArchiveRequest.getArchiveDescription()));
        }
        if (uploadArchiveRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString(uploadArchiveRequest.getChecksum()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/archives";
        uriResourcePath = uriResourcePath.replace("{vaultName}", uploadArchiveRequest.getVaultName() == null ? "" : StringUtils.fromString(uploadArchiveRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{accountId}", uploadArchiveRequest.getAccountId() == null ? "" : StringUtils.fromString(uploadArchiveRequest.getAccountId()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadArchiveRequest.getBody());
        request.addHeader("Content-Type", "binary/octet-stream");
        return request;
    }
}

