/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.jmx.spi.JmxInfoProvider;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.internal.cloudwatch.MachineMetric;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MachineMetricFactory {
    private static final List<MachineMetric> memoryMetrics = Arrays.asList(MachineMetric.TotalMemory, MachineMetric.FreeMemory, MachineMetric.UsedMemory, MachineMetric.SpareMemory);
    private static final List<MachineMetric> threadMetrics = Arrays.asList(MachineMetric.ThreadCount, MachineMetric.DeadLockThreadCount, MachineMetric.DaemonThreadCount, MachineMetric.PeakThreadCount, MachineMetric.TotalStartedThreadCount);
    private static final List<MachineMetric> fdMetrics = Arrays.asList(MachineMetric.OpenFileDescriptorCount, MachineMetric.SpareFileDescriptorCount);
    private final JmxInfoProvider jmxInfoProvider = JmxInfoProvider.Factory.getJmxInfoProvider();

    MachineMetricFactory() {
    }

    private void addMetrics(List<MetricDatum> list, MetricValues metricValues, StandardUnit unit) {
        List<MachineMetric> machineMetrics = metricValues.getMetrics();
        List<Long> values = metricValues.getValues();
        for (int i = 0; i < machineMetrics.size(); ++i) {
            MachineMetric metric = machineMetrics.get(i);
            long val = values.get(i);
            if (val == 0L && !metric.includeZeroValue()) continue;
            MetricDatum datum = new MetricDatum().withMetricName(metric.getMetricName()).withDimensions(new Dimension().withName(metric.getDimensionName()).withValue(metric.name())).withUnit(unit).withValue(Double.valueOf(val));
            list.add(datum);
        }
    }

    private Set<MachineMetric> customMachineMetrics() {
        HashSet<MachineMetric> customized = new HashSet<MachineMetric>();
        for (MetricType m : AwsSdkMetrics.getPredefinedMetrics()) {
            if (!(m instanceof MachineMetric)) continue;
            customized.add((MachineMetric)m);
        }
        return customized;
    }

    private MetricValues metricValues(Set<MachineMetric> customSet, List<MachineMetric> defaults, List<Long> values) {
        List<MachineMetric> actualMetrics = defaults;
        List<Long> actualValues = values;
        if (customSet.size() > 0) {
            actualMetrics = new ArrayList<MachineMetric>();
            actualValues = new ArrayList<Long>();
            for (int i = 0; i < defaults.size(); ++i) {
                MachineMetric mm = defaults.get(i);
                if (!customSet.contains(mm)) continue;
                actualMetrics.add(mm);
                actualValues.add(values.get(i));
            }
        }
        return new MetricValues(actualMetrics, actualValues);
    }

    List<MetricDatum> generateMetrics() {
        if (AwsSdkMetrics.isMachineMetricExcluded()) {
            return Collections.emptyList();
        }
        Set<MachineMetric> customSet = this.customMachineMetrics();
        ArrayList<MetricDatum> targetList = new ArrayList<MetricDatum>(MachineMetric.values().length);
        this.addMemoryMetrics(targetList, customSet);
        try {
            this.addThreadMetrics(targetList, customSet);
        }
        catch (Throwable t) {
            LogFactory.getLog(this.getClass()).debug((Object)"Ignoring thread metrics", t);
        }
        try {
            this.addFileDescriptorMetrics(targetList, customSet);
        }
        catch (Throwable t) {
            LogFactory.getLog(this.getClass()).debug((Object)"Ignoring file descriptor metrics", t);
        }
        return targetList;
    }

    private void addMemoryMetrics(List<MetricDatum> targetList, Set<MachineMetric> customSet) {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        long spareMem = rt.maxMemory() - usedMem;
        List<Long> values = Arrays.asList(totalMem, freeMem, usedMem, spareMem);
        MetricValues metricValues = this.memoryMetricValues(customSet, values);
        this.addMetrics(targetList, metricValues, StandardUnit.Bytes);
    }

    private void addFileDescriptorMetrics(List<MetricDatum> targetList, Set<MachineMetric> customSet) {
        JmxInfoProvider provider = JmxInfoProvider.Factory.getJmxInfoProvider();
        long[] fdInfo = provider.getFileDecriptorInfo();
        if (fdInfo != null) {
            long openFdCount = fdInfo[0];
            long maxFdCount = fdInfo[1];
            List<Long> values = Arrays.asList(openFdCount, maxFdCount - openFdCount);
            MetricValues metricValues = this.fdMetricValues(customSet, values);
            this.addMetrics(targetList, metricValues, StandardUnit.Count);
        }
    }

    private void addThreadMetrics(List<MetricDatum> targetList, Set<MachineMetric> customSet) {
        long threadCount = this.jmxInfoProvider.getThreadCount();
        long[] ids = this.jmxInfoProvider.findDeadlockedThreads();
        long deadLockThreadCount = ids == null ? 0L : (long)ids.length;
        long daemonThreadCount = this.jmxInfoProvider.getDaemonThreadCount();
        long peakThreadCount = this.jmxInfoProvider.getPeakThreadCount();
        long totalStartedThreadCount = this.jmxInfoProvider.getTotalStartedThreadCount();
        List<Long> values = Arrays.asList(threadCount, deadLockThreadCount, daemonThreadCount, peakThreadCount, totalStartedThreadCount);
        MetricValues metricValues = this.threadMetricValues(customSet, values);
        this.addMetrics(targetList, metricValues, StandardUnit.Count);
    }

    private MetricValues memoryMetricValues(Set<MachineMetric> customSet, List<Long> values) {
        return this.metricValues(customSet, memoryMetrics, values);
    }

    private MetricValues fdMetricValues(Set<MachineMetric> customSet, List<Long> values) {
        return this.metricValues(customSet, fdMetrics, values);
    }

    private MetricValues threadMetricValues(Set<MachineMetric> customSet, List<Long> values) {
        return this.metricValues(customSet, threadMetrics, values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetricValues {
        private final List<MachineMetric> metrics;
        private final List<Long> values;

        MetricValues(List<MachineMetric> metrics, List<Long> values) {
            this.metrics = metrics;
            this.values = values;
        }

        List<MachineMetric> getMetrics() {
            return this.metrics;
        }

        List<Long> getValues() {
            return this.values;
        }
    }
}

