/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static SAXBuilder createSAXBuilder() {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return saxBuilder;
    }

    public static String removeComments(String xmlStr) throws JDOMException {
        if (xmlStr == null) {
            return null;
        }
        try {
            SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(xmlStr));
            XmlUtils.removeComments(document);
            return XmlUtils.prettyPrint(document.getRootElement()).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }

    private static void removeComments(List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object node = i.next();
            if (node instanceof Comment) {
                i.remove();
                continue;
            }
            if (!(node instanceof Element)) continue;
            XmlUtils.removeComments(((Element)node).getContent());
        }
    }

    private static void removeComments(Document doc) {
        XmlUtils.removeComments(doc.getContent());
    }

    public static Element parseXml(String xmlStr) throws JDOMException {
        ParamChecker.notNull(xmlStr, "xmlStr");
        try {
            SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(xmlStr));
            return document.getRootElement();
        }
        catch (IOException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }

    public static Element parseXml(InputStream is) throws JDOMException, IOException {
        ParamChecker.notNull(is, "is");
        SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
        Document document = saxBuilder.build(is);
        return document.getRootElement();
    }

    public static String getRootAttribute(String filePath, String attributeName) {
        ParamChecker.notNull(filePath, "filePath");
        ParamChecker.notNull(attributeName, "attributeName");
        SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
        try {
            Document doc = saxBuilder.build(Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath));
            return doc.getRootElement().getAttributeValue(attributeName);
        }
        catch (JDOMException e) {
            throw new RuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static PrettyPrint prettyPrint(Element element) {
        return new PrettyPrint(element);
    }

    public static PrettyPrint prettyPrint(String xmlStr) {
        try {
            return new PrettyPrint(XmlUtils.parseXml(xmlStr));
        }
        catch (Exception e) {
            return new PrettyPrint(xmlStr);
        }
    }

    public static PrettyPrint prettyPrint(Configuration conf) {
        Element root = new Element("configuration");
        for (Map.Entry entry : conf) {
            Element property = new Element("property");
            Element name = new Element("name");
            name.setText((String)entry.getKey());
            Element value = new Element("value");
            value.setText((String)entry.getValue());
            property.addContent((Content)name);
            property.addContent((Content)value);
            root.addContent((Content)property);
        }
        return new PrettyPrint(root);
    }

    public static void validateXml(Schema schema, String xml) throws SAXException, IOException {
        Validator validator = SchemaService.getValidator(schema);
        validator.validate(new StreamSource(new ByteArrayInputStream(xml.getBytes())));
    }

    public static void validateData(String xmlData, SchemaService.SchemaName xsdFile) throws SAXException, IOException {
        if (xmlData == null || xmlData.length() == 0) {
            return;
        }
        Schema schema = Services.get().get(SchemaService.class).getSchema(xsdFile);
        XmlUtils.validateXml(schema, xmlData);
    }

    public static String writePropToString(Properties props) throws IOException {
        try {
            org.w3c.dom.Document doc = XmlUtils.getDocumentBuilder().newDocument();
            org.w3c.dom.Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = props.get(name);
                if (!(object instanceof String)) continue;
                String value = (String)object;
                org.w3c.dom.Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                org.w3c.dom.Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name.trim()));
                propNode.appendChild(nameNode);
                org.w3c.dom.Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value.trim()));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setXIncludeAware(false);
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        docBuilderFactory.setIgnoringComments(true);
        return docBuilderFactory.newDocumentBuilder();
    }

    public static String escapeCharsForXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static Element getSLAElement(Element elem) {
        Element eSla_1 = elem.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
        Element eSla_2 = elem.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.2"));
        Element eSla = eSla_2 != null ? eSla_2 : eSla_1;
        return eSla;
    }

    public static class PrettyPrint {
        private String str;
        private Element element;

        private PrettyPrint(String str) {
            this.str = str;
        }

        private PrettyPrint(Element element) {
            this.element = ParamChecker.notNull(element, "element");
        }

        public String toString() {
            if (this.str != null) {
                return this.str;
            }
            XMLOutputter outputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            outputter.setFormat(Format.getPrettyFormat());
            try {
                outputter.output(this.element, (Writer)stringWriter);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return stringWriter.toString();
        }
    }
}

