/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.xml.sax.SAXException;

public class WorkflowSchemaService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.WorkflowSchemaService.";
    public static final String CONF_EXT_SCHEMAS = "oozie.service.WorkflowSchemaService.ext.schemas";
    private Schema dagSchema;
    private static final String OOZIE_WORKFLOW_XSD = "oozie-workflow-0.1.xsd";

    private Schema loadSchema(Configuration conf) throws SAXException, IOException {
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        sources.add(new StreamSource(IOUtils.getResourceAsStream(OOZIE_WORKFLOW_XSD, -1)));
        String[] schemas = conf.getStrings(CONF_EXT_SCHEMAS);
        if (schemas != null) {
            for (String schema : schemas) {
                sources.add(new StreamSource(IOUtils.getResourceAsStream(schema, -1)));
            }
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(sources.toArray(new StreamSource[sources.size()]));
    }

    @Override
    public void init(Services services) throws ServiceException {
        try {
            this.dagSchema = this.loadSchema(services.getConf());
        }
        catch (SAXException ex) {
            throw new ServiceException(ErrorCode.E0130, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0131, ex.getMessage(), ex);
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return WorkflowSchemaService.class;
    }

    @Override
    public void destroy() {
        this.dagSchema = null;
    }

    public Schema getSchema() {
        return this.dagSchema;
    }
}

