/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluator;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorResult;

public class CoordInputLogicBuilder {
    StringBuffer bf = new StringBuffer();
    CoordInputLogicEvaluator coordInputlogicEvaluator;
    public CoordInputDependencyBuilder dependencyBuilder;

    public CoordInputLogicBuilder(CoordInputLogicEvaluator coordInputlogicEvaluator) {
        this.coordInputlogicEvaluator = coordInputlogicEvaluator;
        this.dependencyBuilder = new CoordInputDependencyBuilder(coordInputlogicEvaluator);
    }

    public CoordInputLogicEvaluatorResult input(String inputDataset) {
        return this.coordInputlogicEvaluator.evalInput(inputDataset, -1, -1);
    }

    public CoordInputLogicEvaluatorResult combine(String ... combineDatasets) {
        return this.coordInputlogicEvaluator.evalCombineInput(combineDatasets, -1, -1);
    }

    public static class CoordInputDependencyBuilder {
        CoordInputLogicEvaluator coordInputLogicEvaluator;
        private int minValue = -1;
        private String wait;
        private String inputDataset;
        private String[] combineDatasets;

        public CoordInputDependencyBuilder(CoordInputLogicEvaluator coordInputLogicEvaluator) {
            this.coordInputLogicEvaluator = coordInputLogicEvaluator;
        }

        public CoordInputDependencyBuilder min(int minValue) {
            this.minValue = minValue;
            return this;
        }

        public CoordInputDependencyBuilder inputWait(String wait) {
            this.wait = wait;
            return this;
        }

        public CoordInputDependencyBuilder inputWait(int wait) {
            this.wait = String.valueOf(wait);
            return this;
        }

        public CoordInputDependencyBuilder input(String dataset) {
            this.inputDataset = dataset;
            return this;
        }

        public CoordInputDependencyBuilder combine(String ... combineDatasets) {
            this.combineDatasets = combineDatasets;
            return this;
        }

        public CoordInputLogicEvaluatorResult build() throws IOException {
            if (this.combineDatasets != null) {
                return this.coordInputLogicEvaluator.evalCombineInput(this.combineDatasets, this.minValue, this.getTime(this.wait));
            }
            return this.coordInputLogicEvaluator.evalInput(this.inputDataset, this.minValue, this.getTime(this.wait));
        }

        private int getTime(String value) throws IOException {
            if (StringUtils.isEmpty((String)value)) {
                return -1;
            }
            if (StringUtils.isNumeric((String)value)) {
                return Integer.parseInt(value);
            }
            throw new IOException("Unsupported time : " + value);
        }
    }
}

