/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundleloader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.docbundle.BundleResourceManagerBackend;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class RepositoryResourceBundleData
extends AbstractResourceData
implements ResourceBundleData {
    private ResourceKey bundleKey;
    private Repository repository;
    private ResourceKey mainKey;
    private ContentLocation root;
    private ContentItem contentItem;
    private static final long serialVersionUID = -1661440107629389952L;

    public RepositoryResourceBundleData(ResourceKey bundleKey, Repository repository, ResourceKey mainKey, boolean failOnMissingData) throws ResourceLoadingException {
        if (bundleKey == null) {
            throw new NullPointerException();
        }
        if (repository == null) {
            throw new NullPointerException();
        }
        if (mainKey == null) {
            throw new NullPointerException();
        }
        try {
            this.bundleKey = bundleKey;
            this.repository = repository;
            this.mainKey = mainKey;
            this.root = repository.getRoot();
            String identifier = (String)mainKey.getIdentifier();
            String[] name = RepositoryUtilities.split((String)identifier, (String)"/");
            if (!RepositoryUtilities.isExistsEntity((Repository)repository, (String[])name)) {
                if (failOnMissingData) {
                    throw new UnrecognizedLoaderException("This bundle data does not point to readable content: " + identifier);
                }
                this.contentItem = null;
            } else {
                ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)repository, (String[])name);
                if (!(contentEntity instanceof ContentItem)) {
                    if (failOnMissingData) {
                        throw new UnrecognizedLoaderException("This bundle data does not point to readable content. Content entity is not a ContentItem");
                    }
                    this.contentItem = null;
                } else {
                    this.contentItem = (ContentItem)contentEntity;
                }
            }
        }
        catch (ContentIOException e) {
            throw new ResourceLoadingException("Failed to create Bundle-Data", (Exception)((Object)e));
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ResourceBundleData deriveData(ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!ObjectUtilities.equal((Object)key.getParent(), (Object)this.bundleKey)) {
            throw new IllegalArgumentException("This key is no derivate of the current bundle.");
        }
        return new RepositoryResourceBundleData(this.bundleKey, this.repository, key, true);
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        if (caller == null) {
            throw new NullPointerException();
        }
        if (this.contentItem == null) {
            throw new ResourceLoadingException("Failure: Missing data");
        }
        try {
            return this.contentItem.getInputStream();
        }
        catch (ContentIOException cioe) {
            throw new ResourceLoadingException("Failure", (Exception)((Object)cioe));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failure", (Exception)e);
        }
    }

    public ResourceKey getBundleKey() {
        return this.bundleKey;
    }

    public Object getAttribute(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.contentItem == null) {
            return null;
        }
        if ("content-type".equals(key)) {
            try {
                return this.contentItem.getMimeType();
            }
            catch (ContentIOException e) {
                return null;
            }
        }
        if ("content-length".equals(key)) {
            return this.contentItem.getAttribute("org.jfree.repository", "size");
        }
        if ("filename".equals(key)) {
            return this.contentItem.getName();
        }
        return null;
    }

    public ResourceKey getKey() {
        return this.mainKey;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        if (caller == null) {
            throw new NullPointerException();
        }
        Object entity = this.contentItem != null ? this.contentItem : this.root;
        Object attribute = entity.getAttribute("org.jfree.repository", "version");
        if (attribute instanceof Number) {
            Number n = (Number)attribute;
            return n.longValue();
        }
        if (attribute instanceof Date) {
            Date d = (Date)attribute;
            return d.getTime();
        }
        return -1L;
    }

    public ResourceManager deriveManager(ResourceManager parent) throws ResourceLoadingException {
        return new ResourceManager(parent, (ResourceManagerBackend)new BundleResourceManagerBackend(this.repository, parent.getBackend(), this.bundleKey));
    }
}

