/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shapefilereader;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shapefilereader.ShapeFileReader;
import org.pentaho.di.shapefilereader.ShapeFileReaderData;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.w3c.dom.Node;

@Step(id="ShapeFileReader", image="ESRI.svg", i18nPackageName="org.pentaho.di.shapefilereader", name="ShapeFileReader.Step.Name", description="ShapeFileReader.Step.Description", documentationUrl="http://wiki.pentaho.com/display/EAI/ESRI+Shapefile+Reader", categoryDescription="Input")
public class ShapeFileReaderMeta
extends BaseStepMeta
implements StepMetaInterface {
    public String shapeFilename;
    public String dbfFilename;

    public String getShapeFilename() {
        return this.shapeFilename;
    }

    public void setShapeFilename(String shapeFilename) {
        this.shapeFilename = shapeFilename;
    }

    public String getDbfFilename() {
        return this.dbfFilename;
    }

    public void setDbfFilename(String dbfFilename) {
        this.dbfFilename = dbfFilename;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        ShapeFileReaderMeta retval = (ShapeFileReaderMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.shapeFilename = XMLHandler.getTagValue((Node)stepnode, (String)"shapefilename");
            this.dbfFilename = XMLHandler.getTagValue((Node)stepnode, (String)"dbffilename");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.shapeFilename = "";
        this.dbfFilename = "";
    }

    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta filename = new ValueMeta("filename", 2);
        filename.setOrigin(name);
        filename.setLength(255);
        row.addValueMeta((ValueMetaInterface)filename);
        ValueMeta ft = new ValueMeta("filetype", 2);
        ft.setLength(50);
        ft.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)ft);
        ValueMeta shnr = new ValueMeta("shapenr", 5);
        shnr.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)shnr);
        ValueMeta pnr = new ValueMeta("partnr", 5);
        pnr.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)pnr);
        ValueMeta nrp = new ValueMeta("nrparts", 5);
        nrp.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)nrp);
        ValueMeta ptnr = new ValueMeta("pointnr", 5);
        ptnr.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)ptnr);
        ValueMeta nrpt = new ValueMeta("nrpointS", 5);
        nrpt.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)nrpt);
        ValueMeta x = new ValueMeta("x", 1);
        x.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)x);
        ValueMeta y = new ValueMeta("y", 1);
        y.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)y);
        ValueMeta m = new ValueMeta("measure", 1);
        m.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)m);
        if (this.getDbfFilename() != null) {
            try (XBase xbase = new XBase(this.getLog(), this.getDbfFilename());){
                xbase.setDbfFile(this.getDbfFilename());
                xbase.open();
                RowMetaInterface fields = xbase.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    fields.getValueMeta(i).setOrigin(name);
                    row.addValueMeta(fields.getValueMeta(i));
                }
            }
        } else {
            throw new KettleStepException("Unable to read from DBF file: no filename specfied");
        }
    }

    public String getXML() {
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue((String)"shapefilename", (String)this.shapeFilename);
        retval = retval + "    " + XMLHandler.addTagValue((String)"dbffilename", (String)this.dbfFilename);
        return retval;
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.shapeFilename = rep.getStepAttributeString(id_step, "shapefilename");
            this.dbfFilename = rep.getStepAttributeString(id_step, "dbffilename");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "shapefilename", this.shapeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "dbffilename", this.dbfFilename);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, "This step is not expecting nor reading any input", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Not receiving any input from other steps.", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.shapeFilename == null || this.dbfFilename == null || this.shapeFilename.length() == 0 || this.dbfFilename.length() == 0) {
            cr = new CheckResult(4, "No files can be found to read.", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Both shape file and the DBF file are defined.", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta si, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans disp) {
        return new ShapeFileReader(si, stepDataInterface, cnr, tr, disp);
    }

    public StepDataInterface getStepData() {
        return new ShapeFileReaderData();
    }
}

