/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

public abstract class AbstractViolationPolicyEnforcement
implements SpaceViolationPolicyEnforcement {
    RegionServerServices rss;
    TableName tableName;
    SpaceQuotaSnapshot quotaSnapshot;

    public void setRegionServerServices(RegionServerServices rss) {
        this.rss = Objects.requireNonNull(rss);
    }

    public void setTableName(TableName tableName) {
        this.tableName = tableName;
    }

    public RegionServerServices getRegionServerServices() {
        return this.rss;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public void setQuotaSnapshot(SpaceQuotaSnapshot snapshot) {
        this.quotaSnapshot = Objects.requireNonNull(snapshot);
    }

    @Override
    public SpaceQuotaSnapshot getQuotaSnapshot() {
        return this.quotaSnapshot;
    }

    @Override
    public void initialize(RegionServerServices rss, TableName tableName, SpaceQuotaSnapshot snapshot) {
        this.setRegionServerServices(rss);
        this.setTableName(tableName);
        this.setQuotaSnapshot(snapshot);
    }

    @Override
    public boolean areCompactionsDisabled() {
        return false;
    }

    @Override
    public boolean shouldCheckBulkLoads() {
        return SpaceQuotaSnapshot.getNoSuchSnapshot() != this.quotaSnapshot;
    }

    @Override
    public void checkBulkLoad(FileSystem fs, List<String> paths) throws SpaceLimitingException {
        long size = 0L;
        for (String path : paths) {
            if (this.quotaSnapshot.getUsage() + (size += this.addSingleFile(fs, path)) <= this.quotaSnapshot.getLimit()) continue;
            break;
        }
        if (this.quotaSnapshot.getUsage() + size > this.quotaSnapshot.getLimit()) {
            throw new SpaceLimitingException(this.getPolicyName(), "Bulk load of " + paths + " is disallowed because the file(s) exceed the limits of a space quota.");
        }
    }

    private long addSingleFile(FileSystem fs, String path) throws SpaceLimitingException {
        FileStatus status;
        try {
            status = fs.getFileStatus(new Path(Objects.requireNonNull(path)));
        }
        catch (IOException e) {
            throw new SpaceLimitingException(this.getPolicyName(), "Could not verify length of file to bulk load", e);
        }
        if (!status.isFile()) {
            throw new IllegalArgumentException(path + " is not a file.");
        }
        return status.getLen();
    }
}

