/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DefaultMobStoreFlusher
extends DefaultStoreFlusher {
    private static final Log LOG = LogFactory.getLog(DefaultMobStoreFlusher.class);
    private final Object flushLock = new Object();
    private long mobCellValueSizeThreshold = 0L;
    private Path targetPath;
    private HMobStore mobStore;

    public DefaultMobStoreFlusher(Configuration conf, Store store) throws IOException {
        super(conf, store);
        this.mobCellValueSizeThreshold = store.getFamily().getMobThreshold();
        this.targetPath = MobUtils.getMobFamilyPath(conf, store.getTableName(), store.getColumnFamilyName());
        if (!this.store.getFileSystem().exists(this.targetPath)) {
            this.store.getFileSystem().mkdirs(this.targetPath);
        }
        this.mobStore = (HMobStore)store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status) throws IOException {
        StoreFile.Writer writer;
        ArrayList<Path> result = new ArrayList<Path>();
        int cellsCount = snapshot.getCellsCount();
        if (cellsCount == 0) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        InternalScanner scanner = this.createScanner(snapshot.getScanner(), smallestReadPoint);
        if (scanner == null) {
            return result;
        }
        try {
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this.store + ": creating writer");
                writer = this.store.createWriterInTmp(cellsCount, this.store.getFamily().getCompression(), false, true, true);
                writer.setTimeRangeTracker(snapshot.getTimeRangeTracker());
                try {
                    this.performMobFlush(snapshot, cacheFlushId, scanner, writer, status);
                }
                finally {
                    this.finalizeWriter(writer, cacheFlushId, status);
                }
            }
        }
        finally {
            scanner.close();
        }
        LOG.info((Object)("Mob store is flushed, sequenceid=" + cacheFlushId + ", memsize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)snapshot.getSize(), (String)"", (int)1) + ", hasBloomFilter=" + writer.hasGeneralBloom() + ", into tmp file " + writer.getPath()));
        result.add(writer.getPath());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performMobFlush(MemStoreSnapshot snapshot, long cacheFlushId, InternalScanner scanner, StoreFile.Writer writer, MonitoredTask status) throws IOException {
        StoreFile.Writer mobFileWriter = null;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        long mobCount = 0L;
        long mobSize = 0L;
        long time = snapshot.getTimeRangeTracker().getMaximumTimestamp();
        mobFileWriter = this.mobStore.createWriterInTmp(new Date(time), snapshot.getCellsCount(), this.store.getFamily().getCompression(), this.store.getRegionInfo().getStartKey());
        byte[] fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
        try {
            boolean hasMore;
            Tag tableNameTag = new Tag(6, this.store.getTableName().getName());
            ArrayList<Cell> cells = new ArrayList<Cell>();
            ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
            do {
                hasMore = scanner.next(cells, scannerContext);
                if (cells.isEmpty()) continue;
                for (Cell c : cells) {
                    if ((long)c.getValueLength() <= this.mobCellValueSizeThreshold || MobUtils.isMobReferenceCell(c) || c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                        writer.append(c);
                        continue;
                    }
                    mobFileWriter.append(c);
                    mobSize += (long)c.getValueLength();
                    ++mobCount;
                    KeyValue reference = MobUtils.createMobRefKeyValue(c, fileName, tableNameTag);
                    writer.append((Cell)reference);
                }
                cells.clear();
            } while (hasMore);
        }
        finally {
            status.setStatus("Flushing mob file " + this.store + ": appending metadata");
            mobFileWriter.appendMetadata(cacheFlushId, false, mobCount);
            status.setStatus("Flushing mob file " + this.store + ": closing flushed file");
            mobFileWriter.close();
        }
        if (mobCount > 0L) {
            this.mobStore.commitFile(mobFileWriter.getPath(), this.targetPath);
            this.mobStore.updateMobFlushCount();
            this.mobStore.updateMobFlushedCellsCount(mobCount);
            this.mobStore.updateMobFlushedCellsSize(mobSize);
        } else {
            try {
                this.store.getFileSystem().delete(mobFileWriter.getPath(), true);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to delete the temp mob file", (Throwable)e);
            }
        }
    }
}

