/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.BackupException;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.BackupProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BackupManifest {
    private static final Log LOG = LogFactory.getLog(BackupManifest.class);
    public static final String MANIFEST_FILE_NAME = ".backup.manifest";
    public static final String MANIFEST_VERSION = "1.0";
    private String version = "1.0";
    protected Configuration config = null;
    private String rootDir = null;
    private String tableBackupDir = null;
    private String logBackupDir = null;
    private String backupId;
    private BackupType type;
    private ArrayList<TableName> tableList;
    private long startTs;
    private long completeTs;
    private Map<TableName, HashMap<String, Long>> incrTimeRanges;
    private Map<String, BackupImage> dependency;

    public BackupManifest(BackupInfo backupCtx) {
        this.backupId = backupCtx.getBackupId();
        this.type = backupCtx.getType();
        this.rootDir = backupCtx.getTargetRootDir();
        if (this.type == BackupType.INCREMENTAL) {
            this.logBackupDir = backupCtx.getHLogTargetDir();
        }
        this.startTs = backupCtx.getStartTs();
        this.completeTs = backupCtx.getEndTs();
        this.loadTableList(backupCtx.getTableNames());
    }

    public BackupManifest(BackupInfo backupCtx, TableName table) {
        this.backupId = backupCtx.getBackupId();
        this.type = backupCtx.getType();
        this.rootDir = backupCtx.getTargetRootDir();
        this.tableBackupDir = backupCtx.getBackupStatus(table).getTargetDir();
        if (this.type == BackupType.INCREMENTAL) {
            this.logBackupDir = backupCtx.getHLogTargetDir();
        }
        this.startTs = backupCtx.getStartTs();
        this.completeTs = backupCtx.getEndTs();
        ArrayList<TableName> tables = new ArrayList<TableName>();
        tables.add(table);
        this.loadTableList(tables);
    }

    public BackupManifest(Configuration conf, Path backupPath) throws BackupException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loading manifest from: " + backupPath.toString()));
        }
        this.tableBackupDir = backupPath.toString();
        this.config = conf;
        try {
            FileSystem fs = backupPath.getFileSystem(conf);
            FileStatus[] subFiles = BackupClientUtil.listStatus((FileSystem)fs, (Path)backupPath, null);
            if (subFiles == null) {
                String errorMsg = backupPath.toString() + " does not exist";
                LOG.error((Object)errorMsg);
                throw new IOException(errorMsg);
            }
            for (FileStatus subFile : subFiles) {
                if (!subFile.getPath().getName().equals(MANIFEST_FILE_NAME)) continue;
                FSDataInputStream in = fs.open(subFile.getPath());
                long len = subFile.getLen();
                byte[] pbBytes = new byte[(int)len];
                in.readFully(pbBytes);
                BackupProtos.BackupManifest proto = null;
                try {
                    proto = BackupManifest.parseFrom(pbBytes);
                }
                catch (Exception e) {
                    throw new BackupException((Throwable)e);
                }
                this.version = proto.getVersion();
                this.backupId = proto.getBackupId();
                this.type = BackupType.valueOf((String)proto.getType().name());
                this.rootDir = backupPath.getParent().getParent().getParent().toString();
                Path p = backupPath.getParent();
                this.rootDir = p.getName().equals("WALs") ? p.getParent().toString() : p.getParent().getParent().toString();
                this.loadTableList(proto);
                this.startTs = proto.getStartTs();
                this.completeTs = proto.getCompleteTs();
                this.loadIncrementalTimestampMap(proto);
                this.loadDependency(proto);
                LOG.debug((Object)("Loaded manifest instance from manifest file: " + BackupClientUtil.getPath((Path)subFile.getPath())));
                return;
            }
            String errorMsg = "No manifest file found in: " + backupPath.toString();
            throw new IOException(errorMsg);
        }
        catch (IOException e) {
            throw new BackupException(e.getMessage());
        }
    }

    private void loadIncrementalTimestampMap(BackupProtos.BackupManifest proto) {
        List list = proto.getTstMapList();
        if (list == null || list.size() == 0) {
            return;
        }
        this.incrTimeRanges = new HashMap<TableName, HashMap<String, Long>>();
        for (BackupProtos.TableServerTimestamp tst : list) {
            TableName tn = ProtobufUtil.toTableName((HBaseProtos.TableName)tst.getTable());
            HashMap<String, Long> map = this.incrTimeRanges.get(tn);
            if (map == null) {
                map = new HashMap();
                this.incrTimeRanges.put(tn, map);
            }
            List listSt = tst.getServerTimestampList();
            for (BackupProtos.ServerTimestamp stm : listSt) {
                map.put(stm.getServer(), stm.getTimestamp());
            }
        }
    }

    private void loadDependency(BackupProtos.BackupManifest proto) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("load dependency for: " + proto.getBackupId()));
        }
        this.dependency = new HashMap<String, BackupImage>();
        List list = proto.getDependentBackupImageList();
        for (BackupProtos.BackupImage im : list) {
            BackupImage bim = BackupImage.fromProto(im);
            if (im.getBackupId() != null) {
                this.dependency.put(im.getBackupId(), bim);
                continue;
            }
            LOG.warn((Object)("Load dependency for backup manifest: " + this.backupId + ". Null backup id in dependent image"));
        }
    }

    private void loadTableList(BackupProtos.BackupManifest proto) {
        this.tableList = new ArrayList();
        List list = proto.getTableListList();
        for (HBaseProtos.TableName name : list) {
            this.tableList.add(ProtobufUtil.toTableName((HBaseProtos.TableName)name));
        }
    }

    public BackupType getType() {
        return this.type;
    }

    public void setType(BackupType type) {
        this.type = type;
    }

    private void loadTableList(List<TableName> tableList) {
        this.tableList = this.getTableList();
        if (this.tableList.size() > 0) {
            this.tableList.clear();
        }
        for (int i = 0; i < tableList.size(); ++i) {
            this.tableList.add(tableList.get(i));
        }
        LOG.debug((Object)(tableList.size() + " tables exist in table set."));
    }

    public ArrayList<TableName> getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    public void store(Configuration conf) throws BackupException {
        byte[] data = this.toByteArray();
        Path manifestFilePath = new Path(new Path(this.tableBackupDir != null ? this.tableBackupDir : this.logBackupDir), MANIFEST_FILE_NAME);
        try {
            FSDataOutputStream out = manifestFilePath.getFileSystem(conf).create(manifestFilePath, true);
            out.write(data);
            out.close();
        }
        catch (IOException e) {
            throw new BackupException(e.getMessage());
        }
        LOG.info((Object)("Manifest file stored to " + manifestFilePath));
    }

    public byte[] toByteArray() {
        BackupProtos.BackupManifest.Builder builder = BackupProtos.BackupManifest.newBuilder();
        builder.setVersion(this.version);
        builder.setBackupId(this.backupId);
        builder.setType(BackupProtos.BackupType.valueOf((String)this.type.name()));
        this.setTableList(builder);
        builder.setStartTs(this.startTs);
        builder.setCompleteTs(this.completeTs);
        this.setIncrementalTimestampMap(builder);
        this.setDependencyMap(builder);
        return builder.build().toByteArray();
    }

    private void setIncrementalTimestampMap(BackupProtos.BackupManifest.Builder builder) {
        if (this.incrTimeRanges == null) {
            return;
        }
        for (Map.Entry<TableName, HashMap<String, Long>> entry : this.incrTimeRanges.entrySet()) {
            TableName key = entry.getKey();
            HashMap<String, Long> value = entry.getValue();
            BackupProtos.TableServerTimestamp.Builder tstBuilder = BackupProtos.TableServerTimestamp.newBuilder();
            tstBuilder.setTable(ProtobufUtil.toProtoTableName((TableName)key));
            for (String s : value.keySet()) {
                BackupProtos.ServerTimestamp.Builder stBuilder = BackupProtos.ServerTimestamp.newBuilder();
                stBuilder.setServer(s);
                stBuilder.setTimestamp(value.get(s).longValue());
                tstBuilder.addServerTimestamp(stBuilder.build());
            }
            builder.addTstMap(tstBuilder.build());
        }
    }

    private void setDependencyMap(BackupProtos.BackupManifest.Builder builder) {
        for (BackupImage image : this.getDependency().values()) {
            builder.addDependentBackupImage(image.toProto());
        }
    }

    private void setTableList(BackupProtos.BackupManifest.Builder builder) {
        for (TableName name : this.tableList) {
            builder.addTableList(ProtobufUtil.toProtoTableName((TableName)name));
        }
    }

    private static BackupProtos.BackupManifest parseFrom(byte[] pbBytes) throws DeserializationException {
        BackupProtos.BackupManifest proto;
        try {
            proto = BackupProtos.BackupManifest.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return proto;
    }

    public String getVersion() {
        return this.version;
    }

    public BackupImage getBackupImage() {
        return this.getDependency().get(this.backupId);
    }

    public void addDependentImage(BackupImage image) {
        this.getDependency().get(this.backupId).addAncestor(image);
        this.setDependencyMap(this.getDependency(), image);
    }

    public Map<String, BackupImage> getDependency() {
        if (this.dependency == null) {
            this.dependency = new HashMap<String, BackupImage>();
            LOG.debug((Object)(this.rootDir + " " + this.backupId + " " + this.type));
            this.dependency.put(this.backupId, new BackupImage(this.backupId, this.type, this.rootDir, this.tableList, this.startTs, this.completeTs));
        }
        return this.dependency;
    }

    public void setIncrTimestampMap(HashMap<TableName, HashMap<String, Long>> incrTimestampMap) {
        this.incrTimeRanges = incrTimestampMap;
    }

    public Map<TableName, HashMap<String, Long>> getIncrTimestampMap() {
        if (this.incrTimeRanges == null) {
            this.incrTimeRanges = new HashMap<TableName, HashMap<String, Long>>();
        }
        return this.incrTimeRanges;
    }

    public ArrayList<BackupImage> getRestoreDependentList(boolean reverse) {
        TreeMap<Long, BackupImage> restoreImages = new TreeMap<Long, BackupImage>();
        for (BackupImage image : this.getDependency().values()) {
            restoreImages.put(image.startTs, image);
        }
        return new ArrayList<BackupImage>(reverse ? restoreImages.descendingMap().values() : restoreImages.values());
    }

    public ArrayList<BackupImage> getDependentListByTable(TableName table) {
        ArrayList<BackupImage> tableImageList = new ArrayList<BackupImage>();
        ArrayList<BackupImage> imageList = this.getRestoreDependentList(true);
        for (BackupImage image : imageList) {
            if (!image.hasTable(table)) continue;
            tableImageList.add(image);
            if (image.getType() != BackupType.FULL) continue;
            break;
        }
        Collections.reverse(tableImageList);
        return tableImageList;
    }

    public ArrayList<BackupImage> getAllDependentListByTable(TableName table) {
        ArrayList<BackupImage> tableImageList = new ArrayList<BackupImage>();
        ArrayList<BackupImage> imageList = this.getRestoreDependentList(false);
        for (BackupImage image : imageList) {
            if (!image.hasTable(table)) continue;
            tableImageList.add(image);
        }
        return tableImageList;
    }

    private void setDependencyMap(Map<String, BackupImage> map, BackupImage image) {
        if (image == null) {
            return;
        }
        map.put(image.getBackupId(), image);
        for (BackupImage img : image.getAncestors()) {
            this.setDependencyMap(map, img);
        }
    }

    public static boolean canCoverImage(BackupImage image1, BackupImage image2) {
        if (image1.getType() == BackupType.INCREMENTAL) {
            return false;
        }
        if (image1.getStartTs() < image2.getStartTs()) {
            return false;
        }
        List<TableName> image1TableList = image1.getTableNames();
        List<TableName> image2TableList = image2.getTableNames();
        boolean found = false;
        for (int i = 0; i < image2TableList.size(); ++i) {
            found = false;
            for (int j = 0; j < image1TableList.size(); ++j) {
                if (!image2TableList.get(i).equals((Object)image1TableList.get(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        LOG.debug((Object)("Backup image " + image1.getBackupId() + " can cover " + image2.getBackupId()));
        return true;
    }

    public static boolean canCoverImage(ArrayList<BackupImage> fullImages, BackupImage image) {
        for (BackupImage image1 : fullImages) {
            if (image1.getType() == BackupType.INCREMENTAL) {
                return false;
            }
            if (image1.getStartTs() >= image.getStartTs()) continue;
            return false;
        }
        ArrayList<String> image1TableList = new ArrayList<String>();
        for (BackupImage image1 : fullImages) {
            List<TableName> tableList = image1.getTableNames();
            for (TableName table : tableList) {
                image1TableList.add(table.getNameAsString());
            }
        }
        ArrayList<String> image2TableList = new ArrayList<String>();
        List<TableName> tableList = image.getTableNames();
        for (TableName table : tableList) {
            image2TableList.add(table.getNameAsString());
        }
        for (int i = 0; i < image2TableList.size(); ++i) {
            if (image1TableList.contains(image2TableList.get(i))) continue;
            return false;
        }
        LOG.debug((Object)("Full image set can cover image " + image.getBackupId()));
        return true;
    }

    public static class BackupImage
    implements Comparable<BackupImage> {
        private String backupId;
        private BackupType type;
        private String rootDir;
        private List<TableName> tableList;
        private long startTs;
        private long completeTs;
        private ArrayList<BackupImage> ancestors;

        public BackupImage() {
        }

        public BackupImage(String backupId, BackupType type, String rootDir, List<TableName> tableList, long startTs, long completeTs) {
            this.backupId = backupId;
            this.type = type;
            this.rootDir = rootDir;
            this.tableList = tableList;
            this.startTs = startTs;
            this.completeTs = completeTs;
        }

        static BackupImage fromProto(BackupProtos.BackupImage im) {
            String backupId = im.getBackupId();
            String rootDir = im.getRootDir();
            long startTs = im.getStartTs();
            long completeTs = im.getCompleteTs();
            List tableListList = im.getTableListList();
            ArrayList<TableName> tableList = new ArrayList<TableName>();
            for (HBaseProtos.TableName tn : tableListList) {
                tableList.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tn));
            }
            List ancestorList = im.getAncestorsList();
            BackupType type = im.getBackupType() == BackupProtos.BackupType.FULL ? BackupType.FULL : BackupType.INCREMENTAL;
            BackupImage image = new BackupImage(backupId, type, rootDir, tableList, startTs, completeTs);
            for (BackupProtos.BackupImage img : ancestorList) {
                image.addAncestor(BackupImage.fromProto(img));
            }
            return image;
        }

        BackupProtos.BackupImage toProto() {
            BackupProtos.BackupImage.Builder builder = BackupProtos.BackupImage.newBuilder();
            builder.setBackupId(this.backupId);
            builder.setCompleteTs(this.completeTs);
            builder.setStartTs(this.startTs);
            builder.setRootDir(this.rootDir);
            if (this.type == BackupType.FULL) {
                builder.setBackupType(BackupProtos.BackupType.FULL);
            } else {
                builder.setBackupType(BackupProtos.BackupType.INCREMENTAL);
            }
            for (TableName name : this.tableList) {
                builder.addTableList(ProtobufUtil.toProtoTableName((TableName)name));
            }
            if (this.ancestors != null) {
                for (BackupImage im : this.ancestors) {
                    builder.addAncestors(im.toProto());
                }
            }
            return builder.build();
        }

        public String getBackupId() {
            return this.backupId;
        }

        public void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public BackupType getType() {
            return this.type;
        }

        public void setType(BackupType type) {
            this.type = type;
        }

        public String getRootDir() {
            return this.rootDir;
        }

        public void setRootDir(String rootDir) {
            this.rootDir = rootDir;
        }

        public List<TableName> getTableNames() {
            return this.tableList;
        }

        public void setTableList(List<TableName> tableList) {
            this.tableList = tableList;
        }

        public long getStartTs() {
            return this.startTs;
        }

        public void setStartTs(long startTs) {
            this.startTs = startTs;
        }

        public long getCompleteTs() {
            return this.completeTs;
        }

        public void setCompleteTs(long completeTs) {
            this.completeTs = completeTs;
        }

        public ArrayList<BackupImage> getAncestors() {
            if (this.ancestors == null) {
                this.ancestors = new ArrayList();
            }
            return this.ancestors;
        }

        public void addAncestor(BackupImage backupImage) {
            this.getAncestors().add(backupImage);
        }

        public boolean hasAncestor(String token) {
            for (BackupImage image : this.getAncestors()) {
                if (!image.getBackupId().equals(token)) continue;
                return true;
            }
            return false;
        }

        public boolean hasTable(TableName table) {
            for (TableName t : this.tableList) {
                if (!t.equals((Object)table)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(BackupImage other) {
            String thisBackupId = this.getBackupId();
            String otherBackupId = other.getBackupId();
            Long thisTS = new Long(thisBackupId.substring(thisBackupId.lastIndexOf("_") + 1));
            Long otherTS = new Long(otherBackupId.substring(otherBackupId.lastIndexOf("_") + 1));
            return thisTS.compareTo(otherTS);
        }
    }
}

