/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.PluginSettings;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.pentaho.SystemPluginResourceAccess;
import pt.webdetails.cpf.utils.XmlDom4JUtils;

public abstract class PentahoBasePluginEnvironment
extends PluginEnvironment
implements IContentAccessFactory {
    private static String pluginId = null;
    private static Log logger = LogFactory.getLog(PentahoPluginEnvironment.class);

    public IContentAccessFactory getContentAccessFactory() {
        return this;
    }

    public IReadAccess getPluginSystemReader(String basePath) {
        return new SystemPluginResourceAccess(((Object)((Object)this)).getClass().getClassLoader(), basePath);
    }

    public IRWAccess getPluginSystemWriter(String basePath) {
        return new SystemPluginResourceAccess(((Object)((Object)this)).getClass().getClassLoader(), basePath);
    }

    public PluginSettings getPluginSettings() {
        return new PluginSettings((IRWAccess)new SystemPluginResourceAccess(((Object)((Object)this)).getClass().getClassLoader(), null));
    }

    public IReadAccess getOtherPluginSystemReader(String pluginId, String basePath) {
        return new SystemPluginResourceAccess(pluginId, basePath);
    }

    public IRWAccess getOtherPluginSystemWriter(String pluginId, String basePath) {
        return new SystemPluginResourceAccess(pluginId, basePath);
    }

    protected String getPluginRepositoryDir() {
        return Util.joinPath((String[])new String[]{"/public", this.getPluginId()});
    }

    public String getPluginId() {
        if (pluginId == null) {
            try {
                SystemPluginResourceAccess reader = new SystemPluginResourceAccess(PentahoBasePluginEnvironment.class.getClassLoader(), null);
                Element documentNode = XmlDom4JUtils.getDocumentFromFile((IReadAccess)reader, (String)"plugin.xml").getRootElement();
                pluginId = documentNode.valueOf("/plugin/@name");
                if (StringUtils.isEmpty((String)pluginId)) {
                    pluginId = documentNode.valueOf("/plugin/@title");
                }
            }
            catch (IOException e) {
                logger.fatal((Object)"Problem reading plugin.xml", (Throwable)e);
                return "cpf";
            }
        }
        return pluginId;
    }
}

