/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.hbase.table;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.transform.Transformer;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.EmptyResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.hadoop.gateway.shell.hbase.table.Attribute;
import org.apache.hadoop.gateway.shell.hbase.table.Family;
import org.apache.hadoop.gateway.shell.hbase.table.FamilyContainer;
import org.apache.hadoop.gateway.util.XmlUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateTable {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response>
    implements FamilyContainer<Request> {
        private static final String ELEMENT_TABLE_SCHEMA = "TableSchema";
        private static final String ELEMENT_COLUMN_SCHEMA = "ColumnSchema";
        private static final String ATTRIBUTE_NAME = "name";
        private String tableName;
        private List<Family<Request>> families = new ArrayList<Family<Request>>();

        public Request(Hadoop session, String tableName) {
            super(session);
            this.tableName = tableName;
        }

        public Family<Request> family(String name) {
            Family<Request> family = new Family<Request>(this, name);
            this.families.add(family);
            return family;
        }

        public Request addFamily(Family<Request> family) {
            this.families.add(family);
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    Document document = XmlUtils.createDocument();
                    Element root = document.createElement(Request.ELEMENT_TABLE_SCHEMA);
                    document.appendChild(root);
                    for (Family family : Request.this.families) {
                        Element columnSchema = document.createElement(Request.ELEMENT_COLUMN_SCHEMA);
                        columnSchema.setAttribute(Request.ATTRIBUTE_NAME, family.name());
                        for (Attribute attribute : family.attributes()) {
                            columnSchema.setAttribute(attribute.getName(), attribute.getValue().toString());
                        }
                        root.appendChild(columnSchema);
                    }
                    StringWriter writer = new StringWriter();
                    Transformer t = XmlUtils.getTransformer((boolean)true, (boolean)false, (int)0, (boolean)false);
                    XmlUtils.writeXml((Document)document, (Writer)writer, (Transformer)t);
                    URIBuilder uri = Request.this.uri(new String[]{"/hbase", "/", Request.this.tableName, "/schema"});
                    HttpPost request = new HttpPost(uri.build());
                    StringEntity entity = new StringEntity(writer.toString(), ContentType.create((String)"text/xml", (String)"UTF-8"));
                    request.setEntity((HttpEntity)entity);
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)request));
                }
            };
        }
    }
}

