/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.gateway.shell.Credentials;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.hadoop.gateway.shell.HadoopException;
import org.apache.hadoop.gateway.shell.knox.token.Get;
import org.apache.hadoop.gateway.shell.knox.token.Token;
import org.apache.hadoop.gateway.util.JsonUtils;

public class KnoxSh {
    private static final String USAGE_PREFIX = "KnoxSh {cmd} [options]";
    private static final String COMMANDS = "   [--help]\n   [init --gateway topology-url]\n   [destroy]\n   [list]\n";
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private Command command;
    private String gateway = null;

    public int run(String[] args) throws Exception {
        int exitCode = 0;
        try {
            exitCode = this.init(args);
            if (exitCode != 0) {
                return exitCode;
            }
            if (this.command != null && this.command.validate()) {
                this.command.execute();
            } else {
                this.out.println("ERROR: Invalid Command\nUnrecognized option:" + args[0] + "\n" + "A fatal exception has occurred. Program will exit.");
                exitCode = -2;
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            this.err.flush();
            return -3;
        }
        return exitCode;
    }

    private int init(String[] args) throws IOException {
        if (args.length == 0) {
            this.printKnoxShellUsage();
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("destroy")) {
                this.command = new KnoxDestroy();
                continue;
            }
            if (args[i].equals("init")) {
                this.command = new KnoxInit();
                continue;
            }
            if (args[i].equals("list")) {
                this.command = new KnoxList();
                continue;
            }
            if (args[i].equals("--gateway")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.gateway = args[++i];
                continue;
            }
            if (args[i].equals("--help")) {
                this.printKnoxShellUsage();
                return -1;
            }
            this.printKnoxShellUsage();
            return -1;
        }
        return 0;
    }

    private void printKnoxShellUsage() {
        this.out.println("KnoxSh {cmd} [options]\n   [--help]\n   [init --gateway topology-url]\n   [destroy]\n   [list]\n");
        if (this.command != null) {
            this.out.println(this.command.getUsage());
        } else {
            char[] chars = new char[79];
            Arrays.fill(chars, '=');
            String div = new String(chars);
            this.out.println(div);
            this.out.println("init --gateway topology-url\n\nInitializes a Knox token session.");
            this.out.println();
            this.out.println(div);
            this.out.println("destroy\n\nDestroys an Knox token session.");
            this.out.println();
            this.out.println(div);
            this.out.println("list\n\nDisplays Knox token details.");
            this.out.println();
            this.out.println(div);
        }
    }

    private void displayTokenDetails(Map<String, String> json) {
        System.out.println("Token Type: " + json.get("token_type"));
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        long milliSeconds = Long.parseLong(json.get("expires_in"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliSeconds);
        System.out.println("Expires On: " + formatter.format(calendar.getTime()));
        String targetUrl = json.get("target_url");
        if (targetUrl != null) {
            System.out.println("Target URL: " + json.get("target_url"));
        } else {
            System.out.println("No specific target URL configured.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        String content = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            content = stringBuilder.toString();
        }
        finally {
            reader.close();
        }
        return content;
    }

    public static void main(String[] args) throws Exception {
        KnoxSh sh = new KnoxSh();
        int res = sh.run(args);
        System.exit(res);
    }

    private class KnoxList
    extends Command {
        public static final String USAGE = "list";
        public static final String DESC = "Displays Knox token details.";

        private KnoxList() {
        }

        @Override
        public void execute() throws Exception {
            String tokenFilePath = System.getProperty("user.home") + File.separator + ".knoxtokencache";
            if (new File(tokenFilePath).exists()) {
                String tokenfile = KnoxSh.this.readFile(tokenFilePath);
                if (tokenfile != null) {
                    Map json = JsonUtils.getMapFromJsonString((String)tokenfile);
                    KnoxSh.this.displayTokenDetails(json);
                }
            } else {
                System.out.println("Knox token cache does not exist. Please login with init.");
            }
        }

        @Override
        public String getUsage() {
            return "list:\n\nDisplays Knox token details.";
        }
    }

    private class KnoxDestroy
    extends Command {
        public static final String USAGE = "destroy";
        public static final String DESC = "Destroys an Knox token session.";

        private KnoxDestroy() {
        }

        @Override
        public void execute() throws Exception {
            File tokenfile = new File(System.getProperty("user.home"), ".knoxtokencache");
            tokenfile.delete();
        }

        @Override
        public String getUsage() {
            return "destroy:\n\nDestroys an Knox token session.";
        }
    }

    private class KnoxInit
    extends Command {
        public static final String USAGE = "init --gateway topology-url";
        public static final String DESC = "Initializes a Knox token session.";

        private KnoxInit() {
        }

        @Override
        public void execute() throws Exception {
            Credentials credentials = new Credentials();
            credentials.add("ClearInput", "Enter username: ", "user").add("HiddenInput", "Enter password: ", "pass");
            credentials.collect();
            String username = credentials.get("user").string();
            String pass = credentials.get("pass").string();
            Hadoop session = null;
            Get.Response response = null;
            try {
                session = Hadoop.login(KnoxSh.this.gateway, username, pass);
                response = (Get.Response)Token.get(session).now();
                String text = response.getString();
                Map json = JsonUtils.getMapFromJsonString((String)text);
                System.out.println("knoxinit successful!");
                KnoxSh.this.displayTokenDetails(json);
                File tokenfile = new File(System.getProperty("user.home"), ".knoxtokencache");
                try (FileOutputStream fos = new FileOutputStream(tokenfile);){
                    fos.write(text.getBytes("UTF-8"));
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_READ);
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    Files.setPosixFilePermissions(Paths.get(System.getProperty("user.home") + "/.knoxtokencache", new String[0]), perms);
                }
            }
            catch (HadoopException he) {
                System.out.println("Failure to acquire token. Please verify your credentials and Knox URL and try again.");
            }
            if (session != null) {
                session.shutdown();
            }
        }

        @Override
        public String getUsage() {
            return "init --gateway topology-url:\n\nInitializes a Knox token session.";
        }
    }

    private abstract class Command {
        private Command() {
        }

        public boolean validate() {
            return true;
        }

        public abstract void execute() throws Exception;

        public abstract String getUsage();
    }
}

