/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell;

import groovy.lang.Closure;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.hadoop.gateway.shell.HadoopException;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractRequest<T> {
    private Hadoop session;

    protected AbstractRequest(Hadoop session) {
        this.session = session;
    }

    protected Hadoop hadoop() {
        return this.session;
    }

    protected CloseableHttpResponse execute(HttpRequest request) throws IOException {
        this.addHeaders(request, this.session.getHeaders());
        return this.session.executeNow(request);
    }

    private void removeHeaders(HttpRequest request, Map<String, String> headers) {
        for (String header : headers.keySet()) {
            request.removeHeaders(header);
        }
    }

    private void addHeaders(HttpRequest request, Map<String, String> headers) {
        for (String header : headers.keySet()) {
            request.setHeader(header, headers.get(header));
        }
    }

    protected URIBuilder uri(String ... parts) throws URISyntaxException {
        return new URIBuilder(this.session.base() + StringUtils.join((Object[])parts));
    }

    protected void addQueryParam(URIBuilder uri, String name, Object value) {
        if (value != null) {
            uri.addParameter(name, value.toString());
        }
    }

    protected void addParam(List<NameValuePair> list, String name, String value) {
        if (value != null) {
            list.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    protected abstract Callable<T> callable();

    public T now() throws HadoopException {
        try {
            return this.callable().call();
        }
        catch (Exception e) {
            throw new HadoopException(e);
        }
    }

    public Future<T> later() {
        return this.hadoop().executeLater(this.callable());
    }

    public Future<T> later(final Closure<Void> closure) {
        return this.hadoop().executeLater(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object result = AbstractRequest.this.callable().call();
                closure.call(result);
                return result;
            }
        });
    }
}

