/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdIntersectClipRect
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_BOTTOM = 3;
    private static final int POS_RIGHT = 2;
    private static final int POS_TOP = 1;
    private static final int POS_LEFT = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Rectangle rect = state.getClipRegion();
        Rectangle2D rec2 = rect.createIntersection(this.getScaledIntersectClipRect());
        state.setClipRegion(new Rectangle((int)rec2.getX(), (int)rec2.getY(), (int)rec2.getWidth(), (int)rec2.getHeight()));
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdIntersectClipRect();
    }

    @Override
    public int getFunction() {
        return 1046;
    }

    public Rectangle getIntersectClipRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getScaledIntersectClipRect() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[INTERSECT_CLIP_RECT] bounds=");
        b.append(this.getIntersectClipRect());
        return b.toString();
    }

    public void setIntersectClipRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    @Override
    public void setRecord(MfRecord record) {
        int bottom = record.getParam(3);
        int right = record.getParam(2);
        int top = record.getParam(1);
        int left = record.getParam(0);
        this.setIntersectClipRect(left, top, right - left, bottom - top);
    }

    @Override
    public MfRecord getRecord() {
        Rectangle rc = this.getIntersectClipRect();
        MfRecord record = new MfRecord(4);
        record.setParam(3, (int)(rc.getY() + rc.getHeight()));
        record.setParam(2, (int)(rc.getX() + rc.getWidth()));
        record.setParam(1, (int)rc.getY());
        record.setParam(0, (int)rc.getX());
        return record;
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
    }
}

