/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import org.pentaho.di.core.encryption.KettleTwoWayPasswordEncoder;
import org.pentaho.platform.api.util.PasswordServiceException;
import org.pentaho.platform.util.Base64PasswordService;
import org.pentaho.platform.util.StringUtil;

public class KettlePasswordService
extends Base64PasswordService {
    String prefix;
    KettleTwoWayPasswordEncoder encoder = new KettleTwoWayPasswordEncoder();

    public KettlePasswordService() {
        String[] prefixes = this.encoder.getPrefixes();
        this.prefix = prefixes[0];
    }

    @Override
    public String encrypt(String password) throws PasswordServiceException {
        if (StringUtil.isEmpty(password)) {
            return password;
        }
        return this.encoder.encode(password);
    }

    @Override
    public String decrypt(String encryptedPassword) throws PasswordServiceException {
        if (StringUtil.isEmpty(encryptedPassword)) {
            return encryptedPassword;
        }
        if (encryptedPassword.startsWith(this.prefix)) {
            return this.encoder.decode(encryptedPassword);
        }
        return super.decrypt(encryptedPassword);
    }
}

