/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.IExecutionListener;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.services.BaseRequestHandler;
import org.pentaho.platform.util.web.SimpleUrlFactory;

public class SolutionHelper {
    public static ISolutionEngine execute(String description, String userId, String actionSequence, Map parameters, OutputStream outputStream) {
        StandaloneSession session = new StandaloneSession(userId);
        return SolutionHelper.execute(description, session, actionSequence, parameters, outputStream, null, true);
    }

    public static ISolutionEngine execute(String description, IPentahoSession session, String actionSequence, Map parameters, OutputStream outputStream) {
        return SolutionHelper.execute(description, session, actionSequence, parameters, outputStream, null, true);
    }

    public static ISolutionEngine execute(String description, IPentahoSession session, String actionSequence, Map parameters, OutputStream outputStream, boolean collateMessages) {
        return SolutionHelper.execute(description, session, actionSequence, parameters, outputStream, null, collateMessages);
    }

    private static ISolutionEngine execute(String description, IPentahoSession session, String actionSequence, Map parameters, OutputStream outputStream, IExecutionListener execListener, boolean collateMessages) {
        return SolutionHelper.execute(description, session, actionSequence, parameters, outputStream, execListener, collateMessages, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISolutionEngine execute(String description, IPentahoSession session, String actionSequence, Map parameters, OutputStream outputStream, IExecutionListener execListener, boolean collateMessages, boolean manageHibernate) {
        if (manageHibernate) {
            PentahoSystem.systemEntryPoint();
        }
        ISolutionEngine solutionEngine = null;
        try {
            solutionEngine = PentahoSystem.get(ISolutionEngine.class, session);
            solutionEngine.init(session);
            solutionEngine.setlistener(execListener);
            SimpleParameterProvider parameterProvider = new SimpleParameterProvider(parameters);
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            String url = requestContext.getContextPath();
            Object actionUrlComponent = parameters.get("action-url-component");
            url = actionUrlComponent != null && actionUrlComponent.toString().length() > 0 ? url + actionUrlComponent.toString() : url + "ViewAction?";
            HashMap<String, SimpleParameterProvider> parameterProviderMap = new HashMap<String, SimpleParameterProvider>();
            parameterProviderMap.put("request", parameterProvider);
            SimpleUrlFactory urlFactory = new SimpleUrlFactory(url);
            String processName = description;
            boolean persisted = false;
            ArrayList messages = null;
            if (collateMessages) {
                messages = new ArrayList();
            }
            if (outputStream == null) {
                outputStream = new ByteArrayOutputStream(0);
            }
            SimpleOutputHandler outputHandler = null;
            if (outputStream != null) {
                outputHandler = new SimpleOutputHandler(outputStream, true);
                outputHandler.setOutputPreference(3);
            }
            solutionEngine.execute(actionSequence, processName, false, true, null, persisted, parameterProviderMap, (IOutputHandler)outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
        }
        finally {
            if (manageHibernate) {
                PentahoSystem.systemExitPoint();
            }
        }
        return solutionEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doAction(String actionPath, String processId, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, ArrayList messages, ILogger logger) {
        int status = 7;
        IRuntimeContext runtime = null;
        try {
            runtime = SolutionHelper.doActionInternal(actionPath, processId, parameterProvider, outputStream, userSession, messages, logger);
            if (runtime != null) {
                status = runtime.getStatus();
            }
        }
        finally {
            if (runtime != null) {
                runtime.dispose();
            }
        }
        return status == 6;
    }

    public static IRuntimeContext doAction(String actionPath, String processId, IParameterProvider parameterProvider, IPentahoSession userSession, ArrayList messages, ILogger logger) {
        return SolutionHelper.doActionInternal(actionPath, processId, parameterProvider, null, userSession, messages, logger);
    }

    private static IRuntimeContext doActionInternal(String actionPath, String processId, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, ArrayList messages, ILogger logger) {
        SimpleOutputHandler outputHandler = new SimpleOutputHandler(outputStream, false);
        BaseRequestHandler requestHandler = new BaseRequestHandler(userSession, null, outputHandler, parameterProvider, null);
        requestHandler.setProcessId(processId);
        requestHandler.setActionPath(actionPath);
        return requestHandler.handleActionRequest(0, 0);
    }
}

