/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp.tenantaware;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.tenantaware.AbstractTenantAwareDatasourceService;
import org.pentaho.platform.engine.services.messages.Messages;
import org.springframework.beans.factory.InitializingBean;

public class TenantAwareSessionVariableDatasourceService
extends AbstractTenantAwareDatasourceService
implements InitializingBean {
    private String tenantSessionVariableName;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.tenantSessionVariableName == null) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("TenantAwareDatasourceService.ERROR_0003_SESSION_VARIABLE_NAME_REQUIRED"));
        }
    }

    @Override
    public String getTenantId() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        Object tenantId = session.getAttribute(this.getTenantSessionVariableName());
        if (tenantId != null) {
            return tenantId.toString();
        }
        return null;
    }

    public void setTenantSessionVariableName(String value) {
        this.tenantSessionVariableName = value;
    }

    public String getTenantSessionVariableName() {
        return this.tenantSessionVariableName;
    }
}

