/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls;

import java.util.Collection;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAclEntry;
import org.pentaho.platform.api.engine.IPentahoBasicAclEntry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class PentahoGrantedAuthorityEffectiveAclsResolver {
    private static final Log logger = LogFactory.getLog(PentahoGrantedAuthorityEffectiveAclsResolver.class);

    public IAclEntry[] resolveEffectiveAcls(IAclEntry[] allAcls, Authentication filteredBy) {
        if (allAcls == null || allAcls.length == 0) {
            return null;
        }
        Vector<IAclEntry> list = new Vector<IAclEntry>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locating AclEntry[]s (from set of " + (allAcls == null ? 0 : allAcls.length) + ") that apply to Authentication: " + filteredBy));
        }
        for (int i = 0; i < allAcls.length; ++i) {
            if (!(allAcls[i] instanceof IPentahoBasicAclEntry)) continue;
            Object recipient = ((IPentahoBasicAclEntry)allAcls[i]).getRecipient();
            if (filteredBy.getPrincipal().equals(recipient)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Principal matches AclEntry recipient: " + recipient));
                }
                list.add(allAcls[i]);
                continue;
            }
            if (filteredBy.getPrincipal() instanceof UserDetails && ((UserDetails)filteredBy.getPrincipal()).getUsername().equals(recipient)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Principal (from UserDetails) matches AclEntry recipient: " + recipient));
                }
                list.add(allAcls[i]);
                continue;
            }
            Collection authoritiesCollection = filteredBy.getAuthorities();
            GrantedAuthority[] authorities = authoritiesCollection.toArray(new GrantedAuthority[0]);
            if (authorities == null || authorities.length == 0) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Did not match principal and there are no granted authorities, so cannot compare with recipient: " + recipient));
                continue;
            }
            for (int k = 0; k < authorities.length; ++k) {
                if (!authorities[k].equals(recipient)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GrantedAuthority: " + authorities[k] + " matches recipient: " + recipient));
                }
                list.add(allAcls[i]);
            }
        }
        if (list.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning effective AclEntry array with " + list.size() + " elements"));
            }
            return list.toArray(new IPentahoBasicAclEntry[0]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Returning null AclEntry array as zero effective AclEntrys found");
        }
        return null;
    }
}

