/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.Collection;
import org.pentaho.platform.engine.security.messages.Messages;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;

public class UseridAttributeLdapContextMapper
extends LdapUserDetailsMapper {
    private String ldapUsernameAttribute = "samAccountName";

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        String usernameAttributeValue = ctx.getStringAttribute(this.getLdapUsernameAttribute());
        if (usernameAttributeValue == null) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("UseridAttributeLdapContextMapper.ERROR_0001_ATTRIBUTE_NOT_FOUND", this.getLdapUsernameAttribute()));
        }
        UserDetails rtn = super.mapUserFromContext(ctx, usernameAttributeValue, authorities);
        return rtn;
    }

    public void setLdapUsernameAttribute(String value) {
        this.ldapUsernameAttribute = value;
    }

    public String getLdapUsernameAttribute() {
        return this.ldapUsernameAttribute;
    }
}

