/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.io.File;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.StandaloneSpringPentahoObjectFactory;
import org.pentaho.platform.engine.core.system.objfac.spring.BarrierBeanPostProcessor;
import org.pentaho.platform.engine.core.system.objfac.spring.BarrierBeanProcessor;
import org.pentaho.platform.engine.core.system.objfac.spring.PentahoBeanScopeValidatorPostProcessor;
import org.pentaho.platform.engine.core.system.objfac.spring.PublishedBeanRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.PriorityOrdered;

public class ApplicationContextPentahoSystemRegisterer
implements ApplicationContextAware,
BeanFactoryPostProcessor,
PriorityOrdered {
    private static boolean barrierBeanFileProcessed;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.safeAddBeanScopePostProcessors(applicationContext);
        StandaloneSpringPentahoObjectFactory objFact = StandaloneSpringPentahoObjectFactory.getInstance(applicationContext);
        PentahoSystem.registerObjectFactory(objFact);
        PublishedBeanRegistry.registerFactory(applicationContext);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)BarrierBeanPostProcessor.getInstance());
        if (!barrierBeanFileProcessed) {
            String barrierBeanFilePath = System.getProperty("PentahoSystemPath") + File.separator + "barrierbean.properties";
            BarrierBeanProcessor.getInstance().registerBarrierBeans(barrierBeanFilePath);
            barrierBeanFileProcessed = true;
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected void safeAddBeanScopePostProcessors(ApplicationContext appCtx) {
        if (appCtx != null && appCtx instanceof AbstractApplicationContext) {
            boolean beanScopePostProcessorExists = false;
            for (BeanFactoryPostProcessor bfpp : ((AbstractApplicationContext)appCtx).getBeanFactoryPostProcessors()) {
                beanScopePostProcessorExists |= bfpp != null && bfpp instanceof PentahoBeanScopeValidatorPostProcessor;
            }
            if (!beanScopePostProcessorExists) {
                ((AbstractApplicationContext)appCtx).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PentahoBeanScopeValidatorPostProcessor());
            }
        }
    }
}

