/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.LoadCaster;
import org.apache.pig.PigStreamingBase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.ToDate;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.WritableByteArray;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.streaming.StreamingDelimiters;
import org.apache.pig.impl.util.StorageUtil;

public class PigStreamingUDF
extends PigStreamingBase {
    private static final byte PRE_WRAP_DELIM = 124;
    private static final byte POST_WRAP_DELIM = 95;
    private static final StreamingDelimiters DELIMS = new StreamingDelimiters(124, 95, false);
    private Schema.FieldSchema topLevelFs;
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private static BagFactory bagFactory = BagFactory.getInstance();
    private WritableByteArray out = new WritableByteArray();

    public PigStreamingUDF() {
    }

    public PigStreamingUDF(Schema.FieldSchema topLevelFs) {
        this.topLevelFs = topLevelFs;
    }

    @Override
    public WritableByteArray serializeToBytes(Tuple t) throws IOException {
        this.out.reset();
        int sz = t == null ? 0 : t.size();
        for (int i = 0; i < sz; ++i) {
            Object field = t.get(i);
            StorageUtil.putField(this.out, field, DELIMS, true);
            if (i == sz - 1) continue;
            this.out.write(DELIMS.getParamDelim());
        }
        byte[] recordDel = DELIMS.getRecordEnd();
        this.out.write(recordDel, 0, recordDel.length);
        return this.out;
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return new Utf8StorageConverter();
    }

    @Override
    public Tuple deserialize(byte[] bytes, int offset, int length) throws IOException {
        Object o = this.deserialize(this.topLevelFs, bytes, 0 + offset, length - DELIMS.getRecordEnd().length);
        return tupleFactory.newTuple(o);
    }

    public byte[] getRecordDelim() {
        return DELIMS.getRecordEnd();
    }

    private Object deserialize(Schema.FieldSchema fs, byte[] bytes, int startIndex, int endIndex) throws IOException {
        if (WritableComparator.compareBytes((byte[])bytes, (int)startIndex, (int)DELIMS.getNull().length, (byte[])DELIMS.getNull(), (int)0, (int)DELIMS.getNull().length) == 0) {
            return null;
        }
        if (fs.type == 120) {
            return this.deserializeBag(fs, bytes, startIndex + 3, endIndex - 2);
        }
        if (fs.type == 110) {
            return this.deserializeTuple(fs, bytes, startIndex + 3, endIndex - 2);
        }
        if (fs.type == 100) {
            return this.deserializeMap(bytes, startIndex + 3, endIndex - 2);
        }
        if (fs.type == 55) {
            return this.extractString(bytes, startIndex, endIndex, true);
        }
        if (fs.type == 50) {
            return new DataByteArray(bytes, startIndex, endIndex + 1);
        }
        String val = this.extractString(bytes, startIndex, endIndex, false);
        if (fs.type == 15) {
            return Long.valueOf(val);
        }
        if (fs.type == 10) {
            return Integer.valueOf(val);
        }
        if (fs.type == 20) {
            return Float.valueOf(val);
        }
        if (fs.type == 25) {
            return Double.valueOf(val);
        }
        if (fs.type == 5) {
            return Boolean.valueOf(val);
        }
        if (fs.type == 30) {
            return ToDate.extractDateTime(val);
        }
        if (fs.type == 65) {
            return new BigInteger(val);
        }
        if (fs.type == 70) {
            return new BigDecimal(val);
        }
        throw new ExecException("Can't deserialize type: " + DataType.findTypeName(fs.type));
    }

    private DataBag deserializeBag(Schema.FieldSchema fs, byte[] buf, int startIndex, int endIndex) throws IOException {
        ArrayList<Tuple> protoBag = new ArrayList<Tuple>();
        int depth = 0;
        int fieldStart = startIndex;
        for (int index = startIndex; index <= endIndex; ++index) {
            depth = DELIMS.updateDepth(buf, depth, index);
            if (!StreamingDelimiters.isDelimiter(DELIMS.getFieldDelim(), buf, index, depth, endIndex)) continue;
            protoBag.add((Tuple)this.deserialize(fs.schema.getField(0), buf, fieldStart, index - 1));
            fieldStart = index + 3;
        }
        return bagFactory.newDefaultBag(protoBag);
    }

    private Tuple deserializeTuple(Schema.FieldSchema fs, byte[] buf, int startIndex, int endIndex) throws IOException {
        Schema tupleSchema = fs.schema;
        ArrayList<Object> protoTuple = new ArrayList<Object>(tupleSchema.size());
        int depth = 0;
        int fieldNum = 0;
        int fieldStart = startIndex;
        for (int index = startIndex; index <= endIndex; ++index) {
            depth = DELIMS.updateDepth(buf, depth, index);
            if (!StreamingDelimiters.isDelimiter(DELIMS.getFieldDelim(), buf, index, depth, endIndex)) continue;
            protoTuple.add(this.deserialize(tupleSchema.getField(fieldNum), buf, fieldStart, index - 1));
            fieldStart = index + 3;
            ++fieldNum;
        }
        return tupleFactory.newTupleNoCopy(protoTuple);
    }

    private Map<String, Object> deserializeMap(byte[] buf, int startIndex, int endIndex) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int depth = 0;
        int fieldStart = startIndex;
        String key = null;
        String val = null;
        for (int index = startIndex; index <= endIndex; ++index) {
            byte currChar = buf[index];
            depth = DELIMS.updateDepth(buf, depth, index);
            if (currChar == DELIMS.getMapKeyDelim() && depth == 0) {
                key = this.extractString(buf, fieldStart, index - 1, true);
                fieldStart = index + 1;
            }
            if (!StreamingDelimiters.isDelimiter(DELIMS.getFieldDelim(), buf, index, depth, endIndex)) continue;
            val = this.extractString(buf, fieldStart, index - 1, true);
            map.put(key, val);
            fieldStart = index + 3;
        }
        return map;
    }

    private String extractString(byte[] bytes, int startIndex, int endIndex, boolean useUtf8) {
        int length = endIndex - startIndex + 1;
        if (useUtf8) {
            return new String(bytes, startIndex, length, Charsets.UTF_8);
        }
        return new String(bytes, startIndex, length, Charset.defaultCharset());
    }
}

