/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.CoordinatorJobEvent;

public abstract class CoordinatorXCommand<T>
extends XCommand<T> {
    public CoordinatorXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public CoordinatorXCommand(String name, String type, int priority, boolean dryrun) {
        super(name, type, priority, dryrun);
    }

    public static void generateEvent(CoordinatorActionBean coordAction, String user, String appName, Date startTime) {
        if (eventService.isSupportedApptype(AppType.COORDINATOR_ACTION.name())) {
            String pushMissDep;
            String missDep = coordAction.getMissingDependencies();
            if (missDep != null && missDep.length() > 0) {
                missDep = missDep.split("#")[0];
            }
            if ((pushMissDep = coordAction.getPushMissingDependencies()) != null && pushMissDep.length() > 0) {
                pushMissDep = pushMissDep.split("#")[0];
            }
            String deps = missDep == null ? (pushMissDep == null ? null : pushMissDep) : (pushMissDep == null ? missDep : missDep + "#" + pushMissDep);
            CoordinatorActionEvent event = new CoordinatorActionEvent(coordAction.getId(), coordAction.getJobId(), coordAction.getStatus(), user, appName, coordAction.getNominalTime(), startTime, deps);
            event.setErrorCode(coordAction.getErrorCode());
            event.setErrorMessage(coordAction.getErrorMessage());
            eventService.queueEvent((Event)event);
        }
    }

    protected void generateEvent(CoordinatorJobBean coordJob) {
        if (eventService.isSupportedApptype(AppType.COORDINATOR_JOB.name())) {
            CoordinatorJobEvent event = new CoordinatorJobEvent(coordJob.getId(), coordJob.getBundleId(), coordJob.getStatus(), coordJob.getUser(), coordJob.getAppName(), coordJob.getStartTime(), coordJob.getEndTime());
            eventService.queueEvent((Event)event);
        }
    }
}

