/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action;

import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class ActionExecutorException
extends Exception {
    private ErrorType errorType;
    private String errorCode;

    public ActionExecutorException(ErrorType errorType, String errorCode, String message) {
        super(message);
        this.errorType = ParamChecker.notNull(errorType, "errorType");
        this.errorCode = ParamChecker.notEmpty(errorCode, "errorCode");
    }

    public ActionExecutorException(ErrorType errorType, String errorCode, String messageTemplate, Object ... params) {
        super(errorCode + ": " + XLog.format(messageTemplate, params), XLog.getCause(params));
        this.errorType = ParamChecker.notNull(errorType, "errorType");
        this.errorCode = ParamChecker.notEmpty(errorCode, "errorCode");
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorType {
        TRANSIENT,
        NON_TRANSIENT,
        ERROR,
        FAILED;

    }
}

